/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.ws.DefaultWebSocketListener;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.internal.BaseResource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceList<T extends HasMetadata, L extends KubernetesResourceList, B extends Builder<T>, D extends Doneable<T>>
extends BaseResource<T, B, D> {
    private Class<L> listClazz;
    private Map<String, String> labels = new TreeMap<String, String>();
    private Map<String, String> fields = new TreeMap<String, String>();

    protected BaseResourceList(AsyncHttpClient httpClient, URL rootUrl, String resourceT, Class<T> clazz, Class<L> listClazz, Class<B> builderClazz, Class<D> updateableClazz) {
        super(httpClient, rootUrl, resourceT, clazz, builderClazz, updateableClazz);
        this.listClazz = listClazz;
    }

    protected Map<String, String> getFields() {
        return this.fields;
    }

    protected Map<String, String> getLabels() {
        return this.labels;
    }

    protected Class<L> getListClazz() {
        return this.listClazz;
    }

    public L list() throws KubernetesClientException {
        try {
            ListenableFuture f;
            Response r;
            Map.Entry<String, String> entry;
            Iterator<Map.Entry<String, String>> iter;
            StringBuilder sb;
            URL requestUrl = this.getNamespacedUrl();
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getHttpClient().prepareGet(requestUrl.toString());
            if (this.labels != null && !this.labels.isEmpty()) {
                sb = new StringBuilder();
                iter = this.labels.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                requestBuilder.addQueryParam("labelSelector", sb.toString());
            }
            if (this.fields != null && !this.fields.isEmpty()) {
                sb = new StringBuilder();
                iter = this.fields.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                requestBuilder.addQueryParam("fieldSelector", sb.toString());
            }
            if ((r = (Response)(f = requestBuilder.execute()).get()).getStatusCode() != 200) {
                Status status = (Status)mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
                throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
            }
            return (L)((KubernetesResourceList)mapper.reader(this.listClazz).readValue(r.getResponseBodyAsStream()));
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public void delete() throws KubernetesClientException {
        try {
            L discoveredResources = this.list();
            for (Object resource : discoveredResources.getItems()) {
                HasMetadata metadataResource = (HasMetadata)resource;
                URL requestUrl = this.getRootUrl();
                if (metadataResource.getMetadata().getNamespace() != null) {
                    requestUrl = new URL(requestUrl, "namespaces/" + metadataResource.getMetadata().getNamespace() + "/");
                }
                requestUrl = new URL(requestUrl, this.getResourceT() + "/" + metadataResource.getMetadata().getName());
                AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getHttpClient().prepareDelete(requestUrl.toString());
                ListenableFuture f = requestBuilder.execute();
                Response r = (Response)f.get();
                if (r.getStatusCode() == 200) continue;
                Status status = (Status)mapper.reader(Status.class).readValue(r.getResponseBodyAsStream());
                throw new KubernetesClientException(status.getMessage(), status.getCode(), status);
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public WebSocket watch(final Watcher<T> watcher) throws KubernetesClientException {
        try {
            Map.Entry<String, String> entry;
            Iterator<Map.Entry<String, String>> iter;
            StringBuilder sb;
            URL requestUrl = this.getNamespacedUrl();
            AsyncHttpClient.BoundRequestBuilder requestBuilder = this.getHttpClient().prepareGet(requestUrl.toString().replaceFirst("^http", "ws"));
            if (this.labels != null && !this.labels.isEmpty()) {
                sb = new StringBuilder();
                iter = this.labels.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                requestBuilder.addQueryParam("labelSelector", sb.toString());
            }
            if (this.fields != null && !this.fields.isEmpty()) {
                sb = new StringBuilder();
                iter = this.fields.entrySet().iterator();
                while (iter.hasNext()) {
                    entry = iter.next();
                    sb.append(entry.getKey()).append("=").append(entry.getValue());
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                }
                requestBuilder.addQueryParam("fieldSelector", sb.toString());
            }
            requestBuilder.addQueryParam("watch", "true");
            ListenableFuture f = requestBuilder.execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new DefaultWebSocketListener(){
                private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

                public void onMessage(String message) {
                    try {
                        WatchEvent event = (WatchEvent)BaseResource.mapper.reader(WatchEvent.class).readValue(message);
                        HasMetadata obj = event.getObject();
                        Watcher.Action action = Watcher.Action.valueOf(event.getType());
                        watcher.eventReceived(action, obj);
                    }
                    catch (IOException e) {
                        this.logger.error("Could not deserialize watch event: {}", (Object)message, (Object)e);
                    }
                    catch (ClassCastException e) {
                        this.logger.error("Received wrong type of object for watch", (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Invalid event type", (Throwable)e);
                    }
                }
            }).build());
            return (WebSocket)f.get();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

