/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.internal;

import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.FilteredNamespacedResourceList;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.NamedNamespacedResource;
import io.fabric8.kubernetes.client.internal.BaseResourceList;
import io.fabric8.kubernetes.client.internal.DefaultResourceList;
import io.fabric8.kubernetes.client.internal.NamedResource;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class NamespacedResourceList<T extends HasMetadata, L extends KubernetesResourceList, B extends Builder<T>, D extends Doneable<T>>
extends BaseResourceList<T, L, B, D>
implements io.fabric8.kubernetes.client.NamespacedResourceList<T, L, B, D>,
FilteredNamespacedResourceList<T, L> {
    NamespacedResourceList(String namespace, DefaultResourceList resourceList) {
        super(resourceList.getHttpClient(), resourceList.getRootUrl(), resourceList.getResourceT(), resourceList.getClazz(), resourceList.getListClazz(), resourceList.getBuilderClazz(), resourceList.getDoneableClazz());
        this.setNamespace(namespace);
    }

    @Override
    public T create(T resource) throws KubernetesClientException {
        try {
            return this.handleCreate(resource);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public D createNew() throws KubernetesClientException {
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    NamespacedResourceList.this.create(resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableClazz().getDeclaredConstructor(Visitor.class).newInstance(visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public FilteredNamespacedResourceList<T, L> withLabels(Map<String, String> labels) {
        this.getLabels().putAll(labels);
        return this;
    }

    @Override
    public FilteredNamespacedResourceList<T, L> withLabel(String key, String value) {
        this.getLabels().put(key, value);
        return this;
    }

    @Override
    public FilteredNamespacedResourceList<T, L> withFields(Map<String, String> labels) {
        this.getFields().putAll(labels);
        return this;
    }

    @Override
    public FilteredNamespacedResourceList<T, L> withField(String key, String value) {
        this.getFields().put(key, value);
        return this;
    }

    @Override
    public NamedNamespacedResource<T, B, D> withName(String name) throws KubernetesClientException {
        try {
            return new NamedResource(name, this);
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

