/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.Reaper;
import io.fabric8.kubernetes.client.dsl.internal.ReaperFactory;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

public class HasMetadataOperation<K extends KubernetesClient, T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>>
extends BaseOperation<K, T, L, D, R> {
    protected HasMetadataOperation(K client, String resourceT, String namespace, String name, Boolean cascading, T item) {
        super(client, resourceT, namespace, name, cascading, item);
    }

    protected HasMetadataOperation(K client, String resourceT, String namespace, String name, Boolean cascading, T item, Class<K> clientType, Class<T> type, Class<L> listType, Class<D> doneableType) {
        super(client, resourceT, namespace, name, cascading, item, clientType, type, listType, doneableType);
    }

    @Override
    public D edit() throws KubernetesClientException {
        final HasMetadataOperation oper = this;
        Visitor visitor = new Visitor<T>(){

            public void visit(T resource) {
                try {
                    Reaper reaper;
                    if (HasMetadataOperation.this.isCascading().booleanValue() && (reaper = ReaperFactory.getReaper(oper)) != null) {
                        reaper.reap();
                    }
                    resource.getMetadata().setResourceVersion(null);
                    HasMetadataOperation.this.handleReplace(HasMetadataOperation.this.getResourceUrl(), resource);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (D)((Doneable)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public T replace(T item) {
        try {
            Reaper reaper;
            if (this.isCascading().booleanValue() && (reaper = ReaperFactory.getReaper(this)) != null) {
                reaper.reap();
            }
            item.getMetadata().setResourceVersion(null);
            mapper.writeValue((OutputStream)System.out, item);
            return (T)((HasMetadata)this.handleReplace(this.getResourceUrl(), item));
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

