/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFluent<T extends ConfigFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    boolean trustCerts;
    String masterUrl;
    String apiVersion;
    String namespace;
    List<String> enabledProtocols = new ArrayList<String>();
    String caCertFile;
    String caCertData;
    String clientCertFile;
    String clientCertData;
    String clientKeyFile;
    String clientKeyData;
    String clientKeyAlgo;
    String clientKeyPassphrase;
    String username;
    String password;
    String oauthToken;
    int watchReconnectInterval;
    int watchReconnectLimit;
    int requestTimeout;
    String proxy;
    Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    public boolean isTrustCerts() {
        return this.trustCerts;
    }

    public T withTrustCerts(boolean trustCerts) {
        this.trustCerts = trustCerts;
        return (T)((Object)this);
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public T withMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
        return (T)((Object)this);
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public T withNamespace(String namespace) {
        this.namespace = namespace;
        return (T)((Object)this);
    }

    public T withEnabledProtocols(String ... enabledProtocols) {
        this.enabledProtocols.clear();
        if (enabledProtocols != null) {
            for (String item : enabledProtocols) {
                this.addToEnabledProtocols(item);
            }
        }
        return (T)((Object)this);
    }

    public String[] getEnabledProtocols() {
        ArrayList<String> result = new ArrayList<String>();
        for (String item : this.enabledProtocols) {
            result.add(item);
        }
        return result.toArray(new String[result.size()]);
    }

    public T addToEnabledProtocols(String ... items) {
        for (String item : items) {
            this.enabledProtocols.add(item);
        }
        return (T)((Object)this);
    }

    public T removeFromEnabledProtocols(String ... items) {
        for (String item : items) {
            this.enabledProtocols.remove(item);
        }
        return (T)((Object)this);
    }

    public String getCaCertFile() {
        return this.caCertFile;
    }

    public T withCaCertFile(String caCertFile) {
        this.caCertFile = caCertFile;
        return (T)((Object)this);
    }

    public String getCaCertData() {
        return this.caCertData;
    }

    public T withCaCertData(String caCertData) {
        this.caCertData = caCertData;
        return (T)((Object)this);
    }

    public String getClientCertFile() {
        return this.clientCertFile;
    }

    public T withClientCertFile(String clientCertFile) {
        this.clientCertFile = clientCertFile;
        return (T)((Object)this);
    }

    public String getClientCertData() {
        return this.clientCertData;
    }

    public T withClientCertData(String clientCertData) {
        this.clientCertData = clientCertData;
        return (T)((Object)this);
    }

    public String getClientKeyFile() {
        return this.clientKeyFile;
    }

    public T withClientKeyFile(String clientKeyFile) {
        this.clientKeyFile = clientKeyFile;
        return (T)((Object)this);
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    public T withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (T)((Object)this);
    }

    public String getClientKeyAlgo() {
        return this.clientKeyAlgo;
    }

    public T withClientKeyAlgo(String clientKeyAlgo) {
        this.clientKeyAlgo = clientKeyAlgo;
        return (T)((Object)this);
    }

    public String getClientKeyPassphrase() {
        return this.clientKeyPassphrase;
    }

    public T withClientKeyPassphrase(String clientKeyPassphrase) {
        this.clientKeyPassphrase = clientKeyPassphrase;
        return (T)((Object)this);
    }

    public String getUsername() {
        return this.username;
    }

    public T withUsername(String username) {
        this.username = username;
        return (T)((Object)this);
    }

    public String getPassword() {
        return this.password;
    }

    public T withPassword(String password) {
        this.password = password;
        return (T)((Object)this);
    }

    public String getOauthToken() {
        return this.oauthToken;
    }

    public T withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (T)((Object)this);
    }

    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    public T withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (T)((Object)this);
    }

    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    public T withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (T)((Object)this);
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public T withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (T)((Object)this);
    }

    public String getProxy() {
        return this.proxy;
    }

    public T withProxy(String proxy) {
        this.proxy = proxy;
        return (T)((Object)this);
    }

    public T addToErrorMessages(Integer key, String value) {
        if (key != null && value != null) {
            this.errorMessages.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromErrorMessages(Integer key) {
        if (key != null) {
            this.errorMessages.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<Integer, String> getErrorMessages() {
        return this.errorMessages;
    }

    public T withErrorMessages(Map<Integer, String> errorMessages) {
        this.errorMessages.clear();
        if (errorMessages != null) {
            this.errorMessages.putAll(errorMessages);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConfigFluent that = (ConfigFluent)((Object)o);
        if (this.trustCerts != that.trustCerts) {
            return false;
        }
        if (this.masterUrl != null ? !this.masterUrl.equals(that.masterUrl) : that.masterUrl != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.enabledProtocols != null ? !this.enabledProtocols.equals(that.enabledProtocols) : that.enabledProtocols != null) {
            return false;
        }
        if (this.caCertFile != null ? !this.caCertFile.equals(that.caCertFile) : that.caCertFile != null) {
            return false;
        }
        if (this.caCertData != null ? !this.caCertData.equals(that.caCertData) : that.caCertData != null) {
            return false;
        }
        if (this.clientCertFile != null ? !this.clientCertFile.equals(that.clientCertFile) : that.clientCertFile != null) {
            return false;
        }
        if (this.clientCertData != null ? !this.clientCertData.equals(that.clientCertData) : that.clientCertData != null) {
            return false;
        }
        if (this.clientKeyFile != null ? !this.clientKeyFile.equals(that.clientKeyFile) : that.clientKeyFile != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.clientKeyAlgo != null ? !this.clientKeyAlgo.equals(that.clientKeyAlgo) : that.clientKeyAlgo != null) {
            return false;
        }
        if (this.clientKeyPassphrase != null ? !this.clientKeyPassphrase.equals(that.clientKeyPassphrase) : that.clientKeyPassphrase != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        return !(this.errorMessages != null ? !this.errorMessages.equals(that.errorMessages) : that.errorMessages != null);
    }
}

