/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientLoggableResource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.utils.URLUtils;
import java.net.URL;

public class PodOperationsImpl
extends HasMetadataOperation<Pod, PodList, DoneablePod, ClientLoggableResource<Pod, DoneablePod>>
implements ClientLoggableResource<Pod, DoneablePod> {
    public PodOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, namespace, null, true, null);
    }

    public PodOperationsImpl(OkHttpClient client, Config config, String namespace, String name, Boolean cascading, Pod item) {
        super(client, config, "pods", namespace, name, cascading, item);
    }

    @Override
    public String getLog() {
        return this.getLog(true);
    }

    @Override
    public String getLog(Boolean isPretty) {
        return this.getLog(null, isPretty);
    }

    @Override
    public String getLog(String containerId) {
        return this.getLog(containerId, true);
    }

    @Override
    public String getLog(String containerId, Boolean isPretty) {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(isPretty);
        if (containerId != null && !containerId.isEmpty()) {
            sb.append("&container=").append(containerId);
        }
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), sb.toString()));
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            this.assertResponseCode(request, response, 200);
            return response.body().string();
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }
}

