/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.AsyncHttpClient;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ListenableFuture;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ws.DefaultWebSocketListener;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ws.WebSocket;
import io.fabric8.kubernetes.client.internal.com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T, L extends KubernetesResourceList>
implements Watch {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AtomicBoolean forceClosed = new AtomicBoolean();
    private final AtomicReference<String> resourceVersion;
    private final BaseOperation<?, T, L, ?, ?> baseOperation;
    private final Watcher<T> watcher;
    private final int reconnectLimit;
    private final int reconnectInterval;
    private final AtomicInteger currentReconnectAttempt = new AtomicInteger(0);
    private WebSocket webSocket;

    WatchConnectionManager(BaseOperation<?, T, L, ?, ?> baseOperation, String version, Watcher<T> watcher, int reconnectInterval, int reconnectLimit) throws InterruptedException, ExecutionException, MalformedURLException {
        if (version == null) {
            L currentList = baseOperation.list();
            this.resourceVersion = new AtomicReference<String>(currentList.getMetadata().getResourceVersion());
        } else {
            this.resourceVersion = new AtomicReference<String>(version);
        }
        this.baseOperation = baseOperation;
        this.watcher = watcher;
        this.reconnectInterval = reconnectInterval;
        this.reconnectLimit = reconnectLimit;
        this.runWatch();
    }

    private final void runWatch() throws MalformedURLException, ExecutionException, InterruptedException {
        String fieldQueryString;
        URL requestUrl = this.baseOperation.getResourceUrl();
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.baseOperation.getClient().getHttpClient().prepareGet(requestUrl.toString().replaceFirst("^http", "ws"));
        String labelQueryParam = this.baseOperation.getLabelQueryParam();
        if (labelQueryParam.length() > 0) {
            requestBuilder.addQueryParam("labelSelector", labelQueryParam);
        }
        if ((fieldQueryString = this.baseOperation.getFieldQueryParam()).length() > 0) {
            requestBuilder.addQueryParam("fieldSelector", fieldQueryString);
        }
        requestBuilder.addQueryParam("resourceVersion", this.resourceVersion.get());
        requestBuilder.addQueryParam("watch", "true");
        WebSocketUpgradeHandler.Builder wsUpgradeBuilder = new WebSocketUpgradeHandler.Builder().addWebSocketListener(new DefaultWebSocketListener(){
            private final Logger logger = LoggerFactory.getLogger(this.getClass());

            @Override
            public void onMessage(String message) {
                try {
                    WatchEvent event = (WatchEvent)mapper.readerFor(WatchEvent.class).readValue(message);
                    HasMetadata obj = event.getObject();
                    String currentResourceVersion = (String)WatchConnectionManager.this.resourceVersion.get();
                    String newResourceVersion = obj.getMetadata().getResourceVersion();
                    if (currentResourceVersion.compareTo(newResourceVersion) < 0) {
                        WatchConnectionManager.this.resourceVersion.compareAndSet(currentResourceVersion, newResourceVersion);
                    }
                    Watcher.Action action = Watcher.Action.valueOf(event.getType());
                    WatchConnectionManager.this.watcher.eventReceived(action, obj);
                }
                catch (IOException e) {
                    this.logger.error("Could not deserialize watch event: {}", (Object)message, (Object)e);
                }
                catch (ClassCastException e) {
                    this.logger.error("Received wrong type of object for watch", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    this.logger.error("Invalid event type", (Throwable)e);
                }
            }

            @Override
            public void onOpen(WebSocket websocket) {
                WatchConnectionManager.this.currentReconnectAttempt.set(0);
                this.webSocket = websocket;
                super.onOpen(websocket);
            }

            @Override
            public void onClose(WebSocket websocket) {
                block7: {
                    if (!WatchConnectionManager.this.forceClosed.get()) {
                        try {
                            WatchConnectionManager.this.runWatch();
                        }
                        catch (ExecutionException e) {
                            if (e.getCause() == null || e.getCause().getCause() == null || !(e.getCause().getCause() instanceof ConnectException)) break block7;
                            if (WatchConnectionManager.this.reconnectLimit >= 0 && WatchConnectionManager.this.currentReconnectAttempt.incrementAndGet() >= WatchConnectionManager.this.reconnectLimit) {
                                throw KubernetesClientException.launderThrowable(e);
                            }
                            try {
                                TimeUnit.MILLISECONDS.sleep(WatchConnectionManager.this.reconnectInterval);
                            }
                            catch (InterruptedException e1) {
                                throw KubernetesClientException.launderThrowable(e);
                            }
                            this.onClose(websocket);
                        }
                        catch (InterruptedException | MalformedURLException e) {
                            throw KubernetesClientException.launderThrowable(e);
                        }
                    }
                }
                super.onClose(websocket);
            }
        });
        ListenableFuture<WebSocket> f = requestBuilder.execute(wsUpgradeBuilder.build());
        this.webSocket = (WebSocket)f.get();
    }

    @Override
    public boolean isOpen() {
        return this.webSocket.isOpen();
    }

    @Override
    public void close() {
        this.forceClosed.set(true);
        this.webSocket.close();
    }
}

