/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mifmif.common.regex.Generex;
import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.model.EditableKubernetesList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Applicable;
import io.fabric8.kubernetes.client.dsl.FromServerGetDeleteRecreateApplicable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.NamespaceFromServerGetDeleteRecreateApplicable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.handlers.KubernetesListHandler;
import io.fabric8.kubernetes.client.utils.ResourceCompare;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceFromServerGetDeleteRecreateApplicableImpl
extends OperationSupport
implements NamespaceFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceFromServerGetDeleteRecreateApplicableImpl.class);
    private static final String EXPRESSION = "expression";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String namespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final Object item;
    private final ResourceHandler hanlder;

    public NamespaceFromServerGetDeleteRecreateApplicableImpl(OkHttpClient client, Config config, String namespace, Boolean fromServer, Boolean deletingExisting, InputStream is) {
        this(client, config, namespace, fromServer, deletingExisting, NamespaceFromServerGetDeleteRecreateApplicableImpl.unmarshal(is));
    }

    public NamespaceFromServerGetDeleteRecreateApplicableImpl(OkHttpClient client, Config config, String namespace, Boolean fromServer, Boolean deletingExisting, Object item) {
        super(client, config, null, null, null, null, null);
        this.namespace = namespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.item = item;
        this.hanlder = NamespaceFromServerGetDeleteRecreateApplicableImpl.handlerOf(item);
        if (this.hanlder == null) {
            throw new KubernetesClientException("No handler found for object:" + item);
        }
    }

    @Override
    public List<HasMetadata> apply() {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata meta : NamespaceFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, true)) {
            ResourceHandler h = NamespaceFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta);
            HasMetadata r = h.reload(this.client, this.config, this.namespace, meta);
            if (r == null) {
                HasMetadata created = h.create(this.client, this.config, this.namespace, meta);
                if (created == null) continue;
                result.add(created);
                continue;
            }
            if (this.deletingExisting.booleanValue()) {
                Boolean deleted = h.delete(this.client, this.config, this.namespace, meta);
                if (!deleted.booleanValue()) {
                    throw new KubernetesClientException("Failed to delete existing item:" + meta);
                }
                HasMetadata created = h.create(this.client, this.config, this.namespace, meta);
                if (created == null) continue;
                result.add(created);
                continue;
            }
            if (ResourceCompare.equals(r, meta)) {
                LOGGER.debug("Item has not changed. Skipping");
                continue;
            }
            HasMetadata replaced = h.replace(this.client, this.config, this.namespace, meta);
            if (replaced == null) continue;
            result.add(replaced);
        }
        return result;
    }

    @Override
    public Boolean delete() {
        for (HasMetadata meta : NamespaceFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, false)) {
            if (NamespaceFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta) != null) continue;
            return false;
        }
        for (HasMetadata meta : NamespaceFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, true)) {
            ResourceHandler h = NamespaceFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta);
            if (h.delete(this.client, this.config, this.namespace != null ? this.namespace : NamespaceFromServerGetDeleteRecreateApplicableImpl.namespaceOf(meta), meta).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<HasMetadata> get() {
        if (this.fromServer.booleanValue()) {
            ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
            for (HasMetadata meta : NamespaceFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, false)) {
                ResourceHandler h = NamespaceFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta);
                HasMetadata reloaded = h.reload(this.client, this.config, this.namespace, meta);
                if (reloaded == null) continue;
                result.add(reloaded);
            }
            return result;
        }
        return NamespaceFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, false);
    }

    private static <T> List<HasMetadata> asHasMetadata(T item, Boolean enableProccessing) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (item instanceof KubernetesList) {
            result.addAll(((KubernetesList)item).getItems());
        } else if (item instanceof Template) {
            if (!enableProccessing.booleanValue()) {
                result.addAll(((Template)item).getObjects());
            } else {
                result.addAll(NamespaceFromServerGetDeleteRecreateApplicableImpl.processTemplate((Template)item, false));
            }
        } else if (item instanceof HasMetadata) {
            result.add((HasMetadata)item);
        }
        return result;
    }

    private static <T> String nameOf(T item) {
        if (item instanceof HasMetadata) {
            return ((HasMetadata)item).getMetadata().getName();
        }
        return null;
    }

    private static <T> String namespaceOf(T item) {
        if (item instanceof HasMetadata) {
            return ((HasMetadata)item).getMetadata().getNamespace();
        }
        return null;
    }

    private static <T> ResourceHandler handlerOf(T item) {
        if (item instanceof HasMetadata) {
            return Handlers.get(((HasMetadata)item).getKind());
        }
        if (item instanceof KubernetesList) {
            return new KubernetesListHandler();
        }
        return null;
    }

    private static List<HasMetadata> processTemplate(Template template, Boolean failOnMissing) {
        List parameters = template != null ? template.getParameters() : null;
        EditableKubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(template.getObjects())).build();
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)list);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    for (Parameter parameter : parameters) {
                        String value;
                        String name = parameter.getName();
                        String regex = "${" + name + "}";
                        if (Utils.isNotNullOrEmpty(parameter.getValue())) {
                            value = parameter.getValue();
                        } else if (EXPRESSION.equals(parameter.getGenerate())) {
                            Generex generex = new Generex(parameter.getFrom());
                            value = generex.random();
                        } else {
                            if (failOnMissing.booleanValue()) {
                                throw new IllegalArgumentException("No value available for parameter name: " + name);
                            }
                            value = "";
                        }
                        json = json.replace(regex, value);
                    }
                }
            }
            list = (KubernetesList)OBJECT_MAPPER.readValue(json, KubernetesList.class);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return list.getItems();
    }

    @Override
    public FromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> inNamespace(String namespace) {
        return new NamespaceFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, namespace, this.fromServer, this.deletingExisting, this.item);
    }

    @Override
    public Gettable<List<HasMetadata>> fromServer() {
        return new NamespaceFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.namespace, (Boolean)true, this.deletingExisting, this.item);
    }

    @Override
    public Applicable<List<HasMetadata>> deletingExisting() {
        return new NamespaceFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.namespace, this.fromServer, (Boolean)true, this.item);
    }
}

