/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.squareup.okhttp.OkHttpClient;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.EditableContainer;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerBuilder;
import io.fabric8.kubernetes.api.model.ReplicationControllerFluent;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.ImageEditReplaceable;
import io.fabric8.kubernetes.client.dsl.Reaper;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplaceable;
import io.fabric8.kubernetes.client.dsl.Watchable;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.ReplicationControllerRollingUpdater;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationControllerOperationsImpl
extends HasMetadataOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>>
implements ClientRollableScallableResource<ReplicationController, DoneableReplicationController>,
TimeoutImageEditReplaceable<ReplicationController, ReplicationController, DoneableReplicationController> {
    static final transient Logger LOG = LoggerFactory.getLogger(ReplicationControllerOperationsImpl.class);
    private final Boolean rolling;
    private final long rollingTimeout;
    private final TimeUnit rollingTimeUnit;

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), false, config.getRollingTimeout(), TimeUnit.MINUTES);
    }

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicationController item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, false, config.getRollingTimeout(), TimeUnit.MINUTES);
    }

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicationController item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit) {
        super(client, config, null, apiVersion, "replicationcontrollers", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.rolling = rolling;
        this.rollingTimeout = rollingTimeout;
        this.rollingTimeUnit = rollingTimeUnit;
        this.reaper = new ReplicationControllerReaper(this);
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> load(InputStream is) {
        try {
            ReplicationController item = ReplicationControllerOperationsImpl.unmarshal(is, ReplicationController.class);
            return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), item, this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ClientNonNamespaceOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, ClientRollableScallableResource<ReplicationController, DoneableReplicationController>> inNamespace(String namespace) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), namespace, this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ImageEditReplaceable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeout, this.rollingTimeUnit);
    }

    @Override
    public ImageEditReplaceable<ReplicationController, ReplicationController, DoneableReplicationController> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ReplicationController scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ClientRollableScallableResource<ReplicationController, DoneableReplicationController> fromServer() {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public Watchable<Watch, Watcher<ReplicationController>> withResourceVersion(String resourceVersion) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicationController)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public EditReplaceDeletable<ReplicationController, ReplicationController, DoneableReplicationController, Boolean> cascading(boolean enabled) {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), enabled, (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicationController scale(int count, boolean wait) {
        ReplicationController res = ((DoneableReplicationController)((ReplicationControllerFluent.SpecNested)((DoneableReplicationController)this.cascading(false).edit()).editSpec().withReplicas(Integer.valueOf(count))).endSpec()).done();
        if (wait) {
            this.waitUntilRCIsScaled();
            res = (ReplicationController)this.getMandatory();
        }
        return res;
    }

    private void waitUntilRCIsScaled() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference atomicRC = new AtomicReference();
        Runnable rcPoller = new Runnable(){

            @Override
            public void run() {
                ReplicationController rc = (ReplicationController)ReplicationControllerOperationsImpl.this.getMandatory();
                atomicRC.set(rc);
                if (Objects.equals(rc.getSpec().getReplicas(), rc.getStatus().getReplicas())) {
                    countDownLatch.countDown();
                } else {
                    LOG.debug("Only {}/{} replicas scheduled for ReplicationController: {} in namespace: {} seconds so waiting...", new Object[]{rc.getStatus().getReplicas(), rc.getSpec().getReplicas(), rc.getMetadata().getName(), ReplicationControllerOperationsImpl.this.namespace});
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(rcPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.rollingTimeout, this.rollingTimeUnit);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            poller.cancel(true);
            executor.shutdown();
            LOG.error("Only {}/{} pod(s) ready for ReplicationController: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{((ReplicationController)atomicRC.get()).getStatus().getReplicas(), ((ReplicationController)atomicRC.get()).getSpec().getReplicas(), ((ReplicationController)atomicRC.get()).getMetadata().getName(), this.namespace, this.rollingTimeUnit.toSeconds(this.rollingTimeout)});
        }
    }

    @Override
    public ReplicationControllerOperationsImpl rolling() {
        return new ReplicationControllerOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicationController)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), true, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicationController updateImage(String image) {
        ReplicationController oldRC = (ReplicationController)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        EditableContainer updatedContainer = ((ContainerBuilder)new ContainerBuilder((Container)oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicationControllerBuilder newRCBuilder = new ReplicationControllerBuilder(oldRC);
        ((ReplicationControllerFluent.SpecNested)((ReplicationControllerSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicationControllerBuilder)((ReplicationControllerFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return (ReplicationController)new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public DoneableReplicationController edit() {
        if (!this.rolling.booleanValue()) {
            return (DoneableReplicationController)super.edit();
        }
        Visitor<ReplicationController> visitor = new Visitor<ReplicationController>(){

            public void visit(ReplicationController rc) {
                try {
                    new ReplicationControllerRollingUpdater(ReplicationControllerOperationsImpl.this.client, ReplicationControllerOperationsImpl.this.config, ReplicationControllerOperationsImpl.this.namespace).rollUpdate((HasMetadata)ReplicationControllerOperationsImpl.this.getMandatory(), rc);
                }
                catch (Exception e) {
                    throw KubernetesClientException.launderThrowable(e);
                }
            }
        };
        try {
            return (DoneableReplicationController)this.getDoneableType().getDeclaredConstructor(this.getType(), Visitor.class).newInstance(this.get(), visitor);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public ReplicationController replace(ReplicationController rc) {
        if (!this.rolling.booleanValue()) {
            return super.replace(rc);
        }
        return new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace, this.rollingTimeUnit.toMillis(this.rollingTimeout), this.getConfig().getLoggingInterval()).rollUpdate((HasMetadata)this.getMandatory(), rc);
    }

    private static class ReplicationControllerReaper
    implements Reaper {
        private ReplicationControllerOperationsImpl oper;

        public ReplicationControllerReaper(ReplicationControllerOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public void reap() {
            this.oper.scale(0, true);
        }
    }
}

