/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mifmif.common.regex.Generex;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.HasMetadataVisitiableBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Applicable;
import io.fabric8.kubernetes.client.dsl.CascadingDeletable;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.NamespaceVisitFromServerGetDeleteRecreateApplicable;
import io.fabric8.kubernetes.client.dsl.VisitFromServerGetDeleteRecreateApplicable;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import io.fabric8.kubernetes.client.handlers.KubernetesListHandler;
import io.fabric8.kubernetes.client.utils.ResourceCompare;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceVisitFromServerGetDeleteRecreateApplicableImpl
extends OperationSupport
implements NamespaceVisitFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.class);
    private static final String EXPRESSION = "expression";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String fallbackNamespace;
    private final String explicitNamespace;
    private final Boolean fromServer;
    private final Boolean deletingExisting;
    private final List<Visitor> visitors;
    private final Object item;
    private final ResourceHandler handler;
    private final long gracePeriodSeconds;
    private final Boolean cascading;

    public NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, InputStream is, Boolean cascading) {
        this(client, config, namespace, explicitNamespace, fromServer, deletingExisting, visitors, NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.unmarshal(is), -1L, cascading);
    }

    public NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(OkHttpClient client, Config config, String namespace, String explicitNamespace, Boolean fromServer, Boolean deletingExisting, List<Visitor> visitors, Object item, long gracePeriodSeconds, Boolean cascading) {
        super(client, config, null, null, null, null, null);
        this.fallbackNamespace = namespace;
        this.explicitNamespace = explicitNamespace;
        this.fromServer = fromServer;
        this.deletingExisting = deletingExisting;
        this.visitors = visitors != null ? new ArrayList<Visitor>(visitors) : new ArrayList();
        this.item = item;
        this.handler = NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.handlerOf(item);
        this.cascading = cascading;
        if (this.handler == null) {
            throw new KubernetesClientException("No handler found for object:" + item);
        }
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.visitors.add((Visitor)new ChangeNamespace(explicitNamespace, this.fallbackNamespace));
    }

    @Override
    public List<HasMetadata> apply() {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata meta : NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, true), this.visitors)) {
            ResourceHandler h = NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta);
            HasMetadata r = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
            String namespaceToUse = meta.getMetadata().getNamespace();
            if (r == null) {
                HasMetadata created = h.create(this.client, this.config, namespaceToUse, meta);
                if (created == null) continue;
                result.add(created);
                continue;
            }
            if (this.deletingExisting.booleanValue()) {
                Boolean deleted = h.delete(this.client, this.config, namespaceToUse, meta);
                if (!deleted.booleanValue()) {
                    throw new KubernetesClientException("Failed to delete existing item:" + meta);
                }
                HasMetadata created = h.create(this.client, this.config, namespaceToUse, meta);
                if (created == null) continue;
                result.add(created);
                continue;
            }
            if (ResourceCompare.equals(r, meta)) {
                LOGGER.debug("Item has not changed. Skipping");
                continue;
            }
            HasMetadata replaced = h.replace(this.client, this.config, namespaceToUse, meta);
            if (replaced == null) continue;
            result.add(replaced);
        }
        return result;
    }

    @Override
    public Boolean delete() {
        for (HasMetadata meta : NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, true), this.visitors)) {
            if (NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta) != null) continue;
            return false;
        }
        for (HasMetadata meta : NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, true), this.visitors)) {
            ResourceHandler h = NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta);
            if (h.delete(this.client, this.config, meta.getMetadata().getNamespace(), meta).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<HasMetadata> get() {
        if (this.fromServer.booleanValue()) {
            ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
            for (HasMetadata meta : NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, true), this.visitors)) {
                ResourceHandler h = NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.handlerOf(meta);
                HasMetadata reloaded = h.reload(this.client, this.config, meta.getMetadata().getNamespace(), meta);
                if (reloaded == null) continue;
                HasMetadata edited = reloaded;
                for (Visitor v : this.visitors) {
                    ((HasMetadataVisitiableBuilder)((HasMetadataVisitiableBuilder)h.edit(edited)).accept(v)).build();
                }
                result.add(reloaded);
            }
            return result;
        }
        return NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.acceptVisitors(NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.asHasMetadata(this.item, true), this.visitors);
    }

    private static List<HasMetadata> acceptVisitors(List<HasMetadata> list, List<Visitor> visitors) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        for (HasMetadata item : list) {
            ResourceHandler h = NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.handlerOf(item);
            Object builder = h.edit(item);
            for (Visitor v : visitors) {
                builder.accept(v);
            }
            result.add((HasMetadata)builder.build());
        }
        return result;
    }

    private static <T> List<HasMetadata> asHasMetadata(T item, Boolean enableProccessing) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (item instanceof KubernetesList) {
            result.addAll(((KubernetesList)item).getItems());
        } else if (item instanceof Template) {
            if (!enableProccessing.booleanValue()) {
                result.addAll(((Template)item).getObjects());
            } else {
                result.addAll(NamespaceVisitFromServerGetDeleteRecreateApplicableImpl.processTemplate((Template)item, false));
            }
        } else if (item instanceof HasMetadata) {
            result.add((HasMetadata)item);
        }
        return result;
    }

    private static <T> String nameOf(T item) {
        if (item instanceof HasMetadata) {
            return ((HasMetadata)item).getMetadata().getName();
        }
        return null;
    }

    private static <T> String namespaceOf(T item) {
        if (item instanceof HasMetadata) {
            return ((HasMetadata)item).getMetadata().getNamespace();
        }
        return null;
    }

    private static <T> ResourceHandler handlerOf(T item) {
        if (item instanceof HasMetadata) {
            return Handlers.get(((HasMetadata)item).getKind());
        }
        if (item instanceof KubernetesList) {
            return new KubernetesListHandler();
        }
        return null;
    }

    private static List<HasMetadata> processTemplate(Template template, Boolean failOnMissing) {
        List parameters = template != null ? template.getParameters() : null;
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(template.getObjects())).build();
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)list);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    for (Parameter parameter : parameters) {
                        String value;
                        String name = parameter.getName();
                        String regex = "${" + name + "}";
                        if (Utils.isNotNullOrEmpty(parameter.getValue())) {
                            value = parameter.getValue();
                        } else if (EXPRESSION.equals(parameter.getGenerate())) {
                            Generex generex = new Generex(parameter.getFrom());
                            value = generex.random();
                        } else {
                            if (failOnMissing.booleanValue()) {
                                throw new IllegalArgumentException("No value available for parameter name: " + name);
                            }
                            value = "";
                        }
                        json = json.replace(regex, value);
                    }
                }
            }
            list = (KubernetesList)OBJECT_MAPPER.readValue(json, KubernetesList.class);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        return list.getItems();
    }

    @Override
    public VisitFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> inNamespace(String explicitNamespace) {
        return new NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.fallbackNamespace, explicitNamespace, this.fromServer, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public Gettable<List<HasMetadata>> fromServer() {
        return new NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, true, this.deletingExisting, this.visitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public Applicable<List<HasMetadata>> deletingExisting() {
        return new NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    public VisitFromServerGetDeleteRecreateApplicable<List<HasMetadata>, Boolean> accept(Visitor visitor) {
        ArrayList<Visitor> newVisitors = new ArrayList<Visitor>(this.visitors);
        newVisitors.add(visitor);
        return new NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, newVisitors, this.item, this.gracePeriodSeconds, this.cascading);
    }

    @Override
    public CascadingDeletable<Boolean> withGracePeriod(long gracePeriodSeconds) {
        return new NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, gracePeriodSeconds, this.cascading);
    }

    @Override
    public Deletable<Boolean> cascading(boolean cascading) {
        return new NamespaceVisitFromServerGetDeleteRecreateApplicableImpl(this.client, this.config, this.fallbackNamespace, this.explicitNamespace, this.fromServer, true, this.visitors, this.item, this.gracePeriodSeconds, cascading);
    }

    private class ChangeNamespace
    extends TypedVisitor<ObjectMetaBuilder> {
        private final String explicitNamespace;
        private final String fallbackNamespace;

        private ChangeNamespace(String explicitNamespace, String fallbackNamespace) {
            this.explicitNamespace = explicitNamespace;
            this.fallbackNamespace = fallbackNamespace;
        }

        public void visit(ObjectMetaBuilder builder) {
            if (Utils.isNotNullOrEmpty(this.explicitNamespace)) {
                builder.withNamespace(this.explicitNamespace);
            } else if (Utils.isNullOrEmpty(builder.getNamespace())) {
                builder.withNamespace(this.fallbackNamespace);
            }
        }
    }
}

