/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.fabric8.kubernetes.client.handlers;

import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.CustomResourceDefinitionOperationsImpl;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

@Component
@Service
public class CustomResourceDefinitionHandler implements ResourceHandler<CustomResourceDefinition, CustomResourceDefinitionBuilder> {

  @Override
  public String getKind() {
    return CustomResourceDefinition.class.getSimpleName();
  }

  @Override
  public CustomResourceDefinition create(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).create();
  }

  @Override
  public CustomResourceDefinition replace(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, true, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).replace(item);
  }

  @Override
  public CustomResourceDefinition reload(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).fromServer().get();
  }

  @Override
  public CustomResourceDefinitionBuilder edit(CustomResourceDefinition item) {
    return new CustomResourceDefinitionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item) {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).delete(item);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, Watcher<CustomResourceDefinition> watcher) {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, String resourceVersion, Watcher<CustomResourceDefinition> watcher) {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).watch(resourceVersion, watcher);
  }

  @Override
  public CustomResourceDefinition waitUntilReady(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CustomResourceDefinition waitUntilCondition(OkHttpClient client, Config config, String namespace, CustomResourceDefinition item, Predicate<CustomResourceDefinition> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CustomResourceDefinitionOperationsImpl(client, config, null, namespace, null, true, item, null, false, -1, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>()).waitUntilCondition(condition, amount, timeUnit);
  }
}
