package io.fabric8.kubernetes.client;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import org.slf4j.Logger;
import java.util.LinkedHashMap;
import java.lang.Integer;
import okhttp3.TlsVersion;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface ConfigFluent<A extends ConfigFluent<A>> extends Fluent<A>{


    public boolean isTrustCerts();
    public A withTrustCerts(boolean trustCerts);
    public Boolean hasTrustCerts();
    public boolean isDisableHostnameVerification();
    public A withDisableHostnameVerification(boolean disableHostnameVerification);
    public Boolean hasDisableHostnameVerification();
    public String getMasterUrl();
    public A withMasterUrl(String masterUrl);
    public Boolean hasMasterUrl();
    public A withNewMasterUrl(String arg1);
    public A withNewMasterUrl(StringBuilder arg1);
    public A withNewMasterUrl(StringBuffer arg1);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);
    public String getCaCertFile();
    public A withCaCertFile(String caCertFile);
    public Boolean hasCaCertFile();
    public A withNewCaCertFile(String arg1);
    public A withNewCaCertFile(StringBuilder arg1);
    public A withNewCaCertFile(StringBuffer arg1);
    public String getCaCertData();
    public A withCaCertData(String caCertData);
    public Boolean hasCaCertData();
    public A withNewCaCertData(String arg1);
    public A withNewCaCertData(StringBuilder arg1);
    public A withNewCaCertData(StringBuffer arg1);
    public String getClientCertFile();
    public A withClientCertFile(String clientCertFile);
    public Boolean hasClientCertFile();
    public A withNewClientCertFile(String arg1);
    public A withNewClientCertFile(StringBuilder arg1);
    public A withNewClientCertFile(StringBuffer arg1);
    public String getClientCertData();
    public A withClientCertData(String clientCertData);
    public Boolean hasClientCertData();
    public A withNewClientCertData(String arg1);
    public A withNewClientCertData(StringBuilder arg1);
    public A withNewClientCertData(StringBuffer arg1);
    public String getClientKeyFile();
    public A withClientKeyFile(String clientKeyFile);
    public Boolean hasClientKeyFile();
    public A withNewClientKeyFile(String arg1);
    public A withNewClientKeyFile(StringBuilder arg1);
    public A withNewClientKeyFile(StringBuffer arg1);
    public String getClientKeyData();
    public A withClientKeyData(String clientKeyData);
    public Boolean hasClientKeyData();
    public A withNewClientKeyData(String arg1);
    public A withNewClientKeyData(StringBuilder arg1);
    public A withNewClientKeyData(StringBuffer arg1);
    public String getClientKeyAlgo();
    public A withClientKeyAlgo(String clientKeyAlgo);
    public Boolean hasClientKeyAlgo();
    public A withNewClientKeyAlgo(String arg1);
    public A withNewClientKeyAlgo(StringBuilder arg1);
    public A withNewClientKeyAlgo(StringBuffer arg1);
    public String getClientKeyPassphrase();
    public A withClientKeyPassphrase(String clientKeyPassphrase);
    public Boolean hasClientKeyPassphrase();
    public A withNewClientKeyPassphrase(String arg1);
    public A withNewClientKeyPassphrase(StringBuilder arg1);
    public A withNewClientKeyPassphrase(StringBuffer arg1);
    public String getTrustStoreFile();
    public A withTrustStoreFile(String trustStoreFile);
    public Boolean hasTrustStoreFile();
    public A withNewTrustStoreFile(String arg1);
    public A withNewTrustStoreFile(StringBuilder arg1);
    public A withNewTrustStoreFile(StringBuffer arg1);
    public String getTrustStorePassphrase();
    public A withTrustStorePassphrase(String trustStorePassphrase);
    public Boolean hasTrustStorePassphrase();
    public A withNewTrustStorePassphrase(String arg1);
    public A withNewTrustStorePassphrase(StringBuilder arg1);
    public A withNewTrustStorePassphrase(StringBuffer arg1);
    public String getKeyStoreFile();
    public A withKeyStoreFile(String keyStoreFile);
    public Boolean hasKeyStoreFile();
    public A withNewKeyStoreFile(String arg1);
    public A withNewKeyStoreFile(StringBuilder arg1);
    public A withNewKeyStoreFile(StringBuffer arg1);
    public String getKeyStorePassphrase();
    public A withKeyStorePassphrase(String keyStorePassphrase);
    public Boolean hasKeyStorePassphrase();
    public A withNewKeyStorePassphrase(String arg1);
    public A withNewKeyStorePassphrase(StringBuilder arg1);
    public A withNewKeyStorePassphrase(StringBuffer arg1);
    public String getUsername();
    public A withUsername(String username);
    public Boolean hasUsername();
    public A withNewUsername(String arg1);
    public A withNewUsername(StringBuilder arg1);
    public A withNewUsername(StringBuffer arg1);
    public String getPassword();
    public A withPassword(String password);
    public Boolean hasPassword();
    public A withNewPassword(String arg1);
    public A withNewPassword(StringBuilder arg1);
    public A withNewPassword(StringBuffer arg1);
    public String getOauthToken();
    public A withOauthToken(String oauthToken);
    public Boolean hasOauthToken();
    public A withNewOauthToken(String arg1);
    public A withNewOauthToken(StringBuilder arg1);
    public A withNewOauthToken(StringBuffer arg1);
    public int getWatchReconnectInterval();
    public A withWatchReconnectInterval(int watchReconnectInterval);
    public Boolean hasWatchReconnectInterval();
    public int getWatchReconnectLimit();
    public A withWatchReconnectLimit(int watchReconnectLimit);
    public Boolean hasWatchReconnectLimit();
    public int getConnectionTimeout();
    public A withConnectionTimeout(int connectionTimeout);
    public Boolean hasConnectionTimeout();
    public int getRequestTimeout();
    public A withRequestTimeout(int requestTimeout);
    public Boolean hasRequestTimeout();
    public long getRollingTimeout();
    public A withRollingTimeout(long rollingTimeout);
    public Boolean hasRollingTimeout();
    public long getScaleTimeout();
    public A withScaleTimeout(long scaleTimeout);
    public Boolean hasScaleTimeout();
    public int getLoggingInterval();
    public A withLoggingInterval(int loggingInterval);
    public Boolean hasLoggingInterval();
    public long getWebsocketTimeout();
    public A withWebsocketTimeout(long websocketTimeout);
    public Boolean hasWebsocketTimeout();
    public long getWebsocketPingInterval();
    public A withWebsocketPingInterval(long websocketPingInterval);
    public Boolean hasWebsocketPingInterval();
    public int getMaxConcurrentRequests();
    public A withMaxConcurrentRequests(int maxConcurrentRequests);
    public Boolean hasMaxConcurrentRequests();
    public int getMaxConcurrentRequestsPerHost();
    public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost);
    public Boolean hasMaxConcurrentRequestsPerHost();
    public String getImpersonateUsername();
    public A withImpersonateUsername(String impersonateUsername);
    public Boolean hasImpersonateUsername();
    public A withNewImpersonateUsername(String arg1);
    public A withNewImpersonateUsername(StringBuilder arg1);
    public A withNewImpersonateUsername(StringBuffer arg1);
    public OAuthTokenProvider getOauthTokenProvider();
    public A withOauthTokenProvider(OAuthTokenProvider oauthTokenProvider);
    public Boolean hasOauthTokenProvider();
    public String getImpersonateGroup();
    public A withImpersonateGroup(String impersonateGroup);
    public Boolean hasImpersonateGroup();
    public A withNewImpersonateGroup(String arg1);
    public A withNewImpersonateGroup(StringBuilder arg1);
    public A withNewImpersonateGroup(StringBuffer arg1);
    public A withImpersonateGroups(String... impersonateGroups);
    public String[] getImpersonateGroups();
    public A addToImpersonateGroups(int index,String item);
    public A setToImpersonateGroups(int index,String item);
    public A addToImpersonateGroups(String... items);
    public A addAllToImpersonateGroups(Collection<String> items);
    public A removeFromImpersonateGroups(String... items);
    public A removeAllFromImpersonateGroups(Collection<String> items);
    public Boolean hasImpersonateGroups();
    public A addNewImpersonateGroup(String arg1);
    public A addNewImpersonateGroup(StringBuilder arg1);
    public A addNewImpersonateGroup(StringBuffer arg1);
    public A addToImpersonateExtras(String key,List<String> value);
    public A addToImpersonateExtras(Map<String,List<String>> map);
    public A removeFromImpersonateExtras(String key);
    public A removeFromImpersonateExtras(Map<String,List<String>> map);
    public Map<String,List<String>> getImpersonateExtras();
    public A withImpersonateExtras(Map<String,List<String>> impersonateExtras);
    public Boolean hasImpersonateExtras();
    public boolean isHttp2Disable();
    public A withHttp2Disable(boolean http2Disable);
    public Boolean hasHttp2Disable();
    public String getHttpProxy();
    public A withHttpProxy(String httpProxy);
    public Boolean hasHttpProxy();
    public A withNewHttpProxy(String arg1);
    public A withNewHttpProxy(StringBuilder arg1);
    public A withNewHttpProxy(StringBuffer arg1);
    public String getHttpsProxy();
    public A withHttpsProxy(String httpsProxy);
    public Boolean hasHttpsProxy();
    public A withNewHttpsProxy(String arg1);
    public A withNewHttpsProxy(StringBuilder arg1);
    public A withNewHttpsProxy(StringBuffer arg1);
    public String getProxyUsername();
    public A withProxyUsername(String proxyUsername);
    public Boolean hasProxyUsername();
    public A withNewProxyUsername(String arg1);
    public A withNewProxyUsername(StringBuilder arg1);
    public A withNewProxyUsername(StringBuffer arg1);
    public String getProxyPassword();
    public A withProxyPassword(String proxyPassword);
    public Boolean hasProxyPassword();
    public A withNewProxyPassword(String arg1);
    public A withNewProxyPassword(StringBuilder arg1);
    public A withNewProxyPassword(StringBuffer arg1);
    public A withNoProxy(String... noProxy);
    public String[] getNoProxy();
    public A addToNoProxy(int index,String item);
    public A setToNoProxy(int index,String item);
    public A addToNoProxy(String... items);
    public A addAllToNoProxy(Collection<String> items);
    public A removeFromNoProxy(String... items);
    public A removeAllFromNoProxy(Collection<String> items);
    public Boolean hasNoProxy();
    public A addNewNoProxy(String arg1);
    public A addNewNoProxy(StringBuilder arg1);
    public A addNewNoProxy(StringBuffer arg1);
    public String getUserAgent();
    public A withUserAgent(String userAgent);
    public Boolean hasUserAgent();
    public A withNewUserAgent(String arg1);
    public A withNewUserAgent(StringBuilder arg1);
    public A withNewUserAgent(StringBuffer arg1);
    public A withTlsVersions(TlsVersion... tlsVersions);
    public TlsVersion[] getTlsVersions();
    public A addToTlsVersions(int index,TlsVersion item);
    public A setToTlsVersions(int index,TlsVersion item);
    public A addToTlsVersions(TlsVersion... items);
    public A addAllToTlsVersions(Collection<TlsVersion> items);
    public A removeFromTlsVersions(TlsVersion... items);
    public A removeAllFromTlsVersions(Collection<TlsVersion> items);
    public Boolean hasTlsVersions();
    public A addToErrorMessages(Integer key,String value);
    public A addToErrorMessages(Map<Integer,String> map);
    public A removeFromErrorMessages(Integer key);
    public A removeFromErrorMessages(Map<Integer,String> map);
    public Map<Integer,String> getErrorMessages();
    public A withErrorMessages(Map<Integer,String> errorMessages);
    public Boolean hasErrorMessages();
    public A addToCustomHeaders(String key,String value);
    public A addToCustomHeaders(Map<String,String> map);
    public A removeFromCustomHeaders(String key);
    public A removeFromCustomHeaders(Map<String,String> map);
    public Map<String,String> getCustomHeaders();
    public A withCustomHeaders(Map<String,String> customHeaders);
    public Boolean hasCustomHeaders();



}
