
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                                                

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.LimitRangeOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class LimitRangeHandler implements ResourceHandler<LimitRange, LimitRangeBuilder> {

  @Override
  public String getKind() {
    return LimitRange.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public LimitRange create(OkHttpClient client, Config config, String namespace, LimitRange item) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public LimitRange replace(OkHttpClient client, Config config, String namespace, LimitRange item) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public LimitRange reload(OkHttpClient client, Config config, String namespace, LimitRange item) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public LimitRangeBuilder edit(LimitRange item) {
    return new LimitRangeBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, LimitRange item) {
    return new LimitRangeOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, LimitRange item, Watcher<LimitRange> watcher) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, LimitRange item, String resourceVersion, Watcher<LimitRange> watcher) {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public LimitRange waitUntilReady(OkHttpClient client, Config config, String namespace, LimitRange item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public LimitRange waitUntilCondition(OkHttpClient client, Config config, String namespace, LimitRange item, Predicate<LimitRange> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new LimitRangeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
