
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                                                

package io.fabric8.kubernetes.client.handlers.metrics.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.metrics.v1beta1.NodeMetricsOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.NodeMetricsBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class NodeMetricsHandler implements ResourceHandler<NodeMetrics, NodeMetricsBuilder> {

  @Override
  public String getKind() {
    return NodeMetrics.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "metrics.k8s.io/v1beta1";
      }

  @Override
  public NodeMetrics create(OkHttpClient client, Config config, String namespace, NodeMetrics item) {
    return new NodeMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public NodeMetrics replace(OkHttpClient client, Config config, String namespace, NodeMetrics item) {
    return new NodeMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public NodeMetrics reload(OkHttpClient client, Config config, String namespace, NodeMetrics item) {
    return new NodeMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public NodeMetricsBuilder edit(NodeMetrics item) {
    return new NodeMetricsBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, NodeMetrics item) {
    return new NodeMetricsOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NodeMetrics item, Watcher<NodeMetrics> watcher) {
    return new NodeMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, NodeMetrics item, String resourceVersion, Watcher<NodeMetrics> watcher) {
    return new NodeMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public NodeMetrics waitUntilReady(OkHttpClient client, Config config, String namespace, NodeMetrics item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new NodeMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public NodeMetrics waitUntilCondition(OkHttpClient client, Config config, String namespace, NodeMetrics item, Predicate<NodeMetrics> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new NodeMetricsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
