
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.LimitRange;
import io.fabric8.kubernetes.api.model.LimitRangeList;
import io.fabric8.kubernetes.api.model.DoneableLimitRange;

import java.util.Map;
import java.util.TreeMap;


public class LimitRangeOperationsImpl extends HasMetadataOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> {

  public LimitRangeOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public LimitRangeOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public LimitRangeOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("limitranges"));
    this.type = LimitRange.class;
    this.listType = LimitRangeList.class;
    this.doneableType = DoneableLimitRange.class;
  }

  public LimitRangeOperationsImpl newInstance(OperationContext context) {
    return new LimitRangeOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
