
                                          

package io.fabric8.kubernetes.client.handlers.storage.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1.VolumeAttachmentOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachment;
import io.fabric8.kubernetes.api.model.storage.VolumeAttachmentBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class VolumeAttachmentHandler implements ResourceHandler<VolumeAttachment, VolumeAttachmentBuilder> {

  @Override
  public String getKind() {
    return VolumeAttachment.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "storage.k8s.io/v1";
      }

  @Override
  public VolumeAttachment create(OkHttpClient client, Config config, String namespace, VolumeAttachment item) {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public VolumeAttachment replace(OkHttpClient client, Config config, String namespace, VolumeAttachment item) {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public VolumeAttachment reload(OkHttpClient client, Config config, String namespace, VolumeAttachment item) {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public VolumeAttachmentBuilder edit(VolumeAttachment item) {
    return new VolumeAttachmentBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, VolumeAttachment item) {
    return new VolumeAttachmentOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeAttachment item, Watcher<VolumeAttachment> watcher) {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeAttachment item, String resourceVersion, Watcher<VolumeAttachment> watcher) {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, VolumeAttachment item, ListOptions options, Watcher<VolumeAttachment> watcher) {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public VolumeAttachment waitUntilReady(OkHttpClient client, Config config, String namespace, VolumeAttachment item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public VolumeAttachment waitUntilCondition(OkHttpClient client, Config config, String namespace, VolumeAttachment item, Predicate<VolumeAttachment> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new VolumeAttachmentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
