package io.fabric8.kubernetes.client.extended.leaderelection;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.time.Duration;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;

public class LeaderElectionConfigFluentImpl<A extends LeaderElectionConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LeaderElectionConfigFluent<A> {

    private Lock lock;
    private Duration leaseDuration;
    private Duration renewDeadline;
    private Duration retryPeriod;
    private LeaderCallbacks leaderCallbacks;
    private boolean releaseOnCancel;
    private String name;

    public LeaderElectionConfigFluentImpl() { 
    }


    public LeaderElectionConfigFluentImpl(LeaderElectionConfig instance) { 
        this.withLock(instance.getLock()); 
        this.withLeaseDuration(instance.getLeaseDuration()); 
        this.withRenewDeadline(instance.getRenewDeadline()); 
        this.withRetryPeriod(instance.getRetryPeriod()); 
        this.withLeaderCallbacks(instance.getLeaderCallbacks()); 
        this.withReleaseOnCancel(instance.isReleaseOnCancel()); 
        this.withName(instance.getName()); 
    }


    public Lock getLock() {
        return this.lock;
    }

    public A withLock(Lock lock) {
        this.lock=lock; return (A) this;
    }

    public Boolean hasLock() {
        return this.lock != null;
    }

    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public A withLeaseDuration(Duration leaseDuration) {
        this.leaseDuration=leaseDuration; return (A) this;
    }

    public Boolean hasLeaseDuration() {
        return this.leaseDuration != null;
    }

    public Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    public A withRenewDeadline(Duration renewDeadline) {
        this.renewDeadline=renewDeadline; return (A) this;
    }

    public Boolean hasRenewDeadline() {
        return this.renewDeadline != null;
    }

    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    public A withRetryPeriod(Duration retryPeriod) {
        this.retryPeriod=retryPeriod; return (A) this;
    }

    public Boolean hasRetryPeriod() {
        return this.retryPeriod != null;
    }

    public LeaderCallbacks getLeaderCallbacks() {
        return this.leaderCallbacks;
    }

    public A withLeaderCallbacks(LeaderCallbacks leaderCallbacks) {
        this.leaderCallbacks=leaderCallbacks; return (A) this;
    }

    public Boolean hasLeaderCallbacks() {
        return this.leaderCallbacks != null;
    }

    public boolean isReleaseOnCancel() {
        return this.releaseOnCancel;
    }

    public A withReleaseOnCancel(boolean releaseOnCancel) {
        this.releaseOnCancel=releaseOnCancel; return (A) this;
    }

    public Boolean hasReleaseOnCancel() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LeaderElectionConfigFluentImpl that = (LeaderElectionConfigFluentImpl) o;
        if (lock != null ? !lock.equals(that.lock) :that.lock != null) return false;
        if (leaseDuration != null ? !leaseDuration.equals(that.leaseDuration) :that.leaseDuration != null) return false;
        if (renewDeadline != null ? !renewDeadline.equals(that.renewDeadline) :that.renewDeadline != null) return false;
        if (retryPeriod != null ? !retryPeriod.equals(that.retryPeriod) :that.retryPeriod != null) return false;
        if (leaderCallbacks != null ? !leaderCallbacks.equals(that.leaderCallbacks) :that.leaderCallbacks != null) return false;
        if (releaseOnCancel != that.releaseOnCancel) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(lock,  leaseDuration,  renewDeadline,  retryPeriod,  leaderCallbacks,  releaseOnCancel,  name,  super.hashCode());
    }

}
