/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers;

import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.internal.DeploymentOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DeploymentHandler
implements ResourceHandler<Deployment, DeploymentBuilder> {
    @Override
    public String getKind() {
        return Deployment.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps/v1";
    }

    @Override
    public Deployment create(OkHttpClient client, Config config, String namespace, Deployment item) {
        return (Deployment)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Deployment[0]);
    }

    @Override
    public Deployment replace(OkHttpClient client, Config config, String namespace, Deployment item) {
        return (Deployment)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Deployment reload(OkHttpClient client, Config config, String namespace, Deployment item) {
        return (Deployment)((Gettable)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public DeploymentBuilder edit(Deployment item) {
        return new DeploymentBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Deployment item) {
        return (Boolean)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Deployment item, Watcher<Deployment> watcher) {
        return (Watch)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Deployment item, String resourceVersion, Watcher<Deployment> watcher) {
        return (Watch)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Deployment waitUntilReady(OkHttpClient client, Config config, String namespace, Deployment item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Deployment)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Deployment waitUntilCondition(OkHttpClient client, Config config, String namespace, Deployment item, Predicate<Deployment> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Deployment)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

