
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.coordination.v1beta1.DoneableLease;
import io.fabric8.kubernetes.api.model.coordination.v1beta1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1beta1.LeaseList;
import io.fabric8.kubernetes.api.model.coordination.v1beta1.DoneableLease;

import java.util.Map;
import java.util.TreeMap;


public class LeaseOperationsImpl extends HasMetadataOperation<Lease, LeaseList, DoneableLease, Resource<Lease, DoneableLease>> {

  public LeaseOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public LeaseOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace));
  }

  public LeaseOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("coordination.k8s.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("leases"));
    this.type = Lease.class;
    this.listType = LeaseList.class;
    this.doneableType = DoneableLease.class;
  }

  public LeaseOperationsImpl newInstance(OperationContext context) {
    return new LeaseOperationsImpl(context);
  }
}
