
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.extensions.DoneableIngress;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.DoneableIngress;

import java.util.Map;
import java.util.TreeMap;


public class IngressOperationsImpl extends HasMetadataOperation<Ingress, IngressList, DoneableIngress, Resource<Ingress, DoneableIngress>> {

  public IngressOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public IngressOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace));
  }

  public IngressOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("extensions")
    .withApiGroupVersion("v1beta1")
    .withPlural("ingresses"));
    this.type = Ingress.class;
    this.listType = IngressList.class;
    this.doneableType = DoneableIngress.class;
  }

  public IngressOperationsImpl newInstance(OperationContext context) {
    return new IngressOperationsImpl(context);
  }
}
