
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.v1beta1.DoneableCSINode;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeList;
import io.fabric8.kubernetes.api.model.storage.v1beta1.DoneableCSINode;

import java.util.Map;
import java.util.TreeMap;


public class CSINodeOperationsImpl extends HasMetadataOperation<CSINode, CSINodeList, DoneableCSINode, Resource<CSINode, DoneableCSINode>> {

  public CSINodeOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public CSINodeOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace));
  }

  public CSINodeOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("storage.k8s.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("csinodes"));
    this.type = CSINode.class;
    this.listType = CSINodeList.class;
    this.doneableType = DoneableCSINode.class;
  }

  public CSINodeOperationsImpl newInstance(OperationContext context) {
    return new CSINodeOperationsImpl(context);
  }
}
