
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.rbac.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleList;

import java.util.Map;
import java.util.TreeMap;


public class ClusterRoleOperationsImpl extends HasMetadataOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> {

  public ClusterRoleOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public ClusterRoleOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ClusterRoleOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("rbac.authorization.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("clusterroles"));
    this.type = ClusterRole.class;
    this.listType = ClusterRoleList.class;
  }

  public ClusterRoleOperationsImpl newInstance(OperationContext context) {
    return new ClusterRoleOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
