
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;

import java.util.Map;
import java.util.TreeMap;


public class ConfigMapOperationsImpl extends HasMetadataOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> {

  public ConfigMapOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public ConfigMapOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConfigMapOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("")
    .withApiGroupVersion("v1")
    .withPlural("configmaps"));
    this.type = ConfigMap.class;
    this.listType = ConfigMapList.class;
  }

  public ConfigMapOperationsImpl newInstance(OperationContext context) {
    return new ConfigMapOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
