
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.rbac.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleList;

import java.util.Map;
import java.util.TreeMap;


public class RoleOperationsImpl extends HasMetadataOperation<Role, RoleList, Resource<Role>> {

  public RoleOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public RoleOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public RoleOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("rbac.authorization.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("roles"));
    this.type = Role.class;
    this.listType = RoleList.class;
  }

  public RoleOperationsImpl newInstance(OperationContext context) {
    return new RoleOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
