
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.storage.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.StorageClassList;

import java.util.Map;
import java.util.TreeMap;


public class StorageClassOperationsImpl extends HasMetadataOperation<StorageClass, StorageClassList, Resource<StorageClass>> {

  public StorageClassOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public StorageClassOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public StorageClassOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("storage.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("storageclasses"));
    this.type = StorageClass.class;
    this.listType = StorageClassList.class;
  }

  public StorageClassOperationsImpl newInstance(OperationContext context) {
    return new StorageClassOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
