
                                          

package io.fabric8.kubernetes.client.handlers.networking.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.networking.v1beta1.IngressClassOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class IngressClassHandler implements ResourceHandler<IngressClass, IngressClassBuilder> {

  @Override
  public String getKind() {
    return IngressClass.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "networking.k8s.io/v1beta1";
      }

  @Override
  public IngressClass create(OkHttpClient client, Config config, String namespace, IngressClass item) {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public IngressClass replace(OkHttpClient client, Config config, String namespace, IngressClass item) {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public IngressClass reload(OkHttpClient client, Config config, String namespace, IngressClass item) {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public IngressClassBuilder edit(IngressClass item) {
    return new IngressClassBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, IngressClass item) {
    return new IngressClassOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IngressClass item, Watcher<IngressClass> watcher) {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IngressClass item, String resourceVersion, Watcher<IngressClass> watcher) {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, IngressClass item, ListOptions options, Watcher<IngressClass> watcher) {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public IngressClass waitUntilReady(OkHttpClient client, Config config, String namespace, IngressClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public IngressClass waitUntilCondition(OkHttpClient client, Config config, String namespace, IngressClass item, Predicate<IngressClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
