
                                          

package io.fabric8.kubernetes.client.handlers.apps.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.ReplicaSetOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ReplicaSetHandler implements ResourceHandler<ReplicaSet, ReplicaSetBuilder> {

  @Override
  public String getKind() {
    return ReplicaSet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apps/v1";
      }

  @Override
  public ReplicaSet create(OkHttpClient client, Config config, String namespace, ReplicaSet item) {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ReplicaSet replace(OkHttpClient client, Config config, String namespace, ReplicaSet item) {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ReplicaSet reload(OkHttpClient client, Config config, String namespace, ReplicaSet item) {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ReplicaSetBuilder edit(ReplicaSet item) {
    return new ReplicaSetBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ReplicaSet item) {
    return new ReplicaSetOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ReplicaSet item, Watcher<ReplicaSet> watcher) {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ReplicaSet item, String resourceVersion, Watcher<ReplicaSet> watcher) {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ReplicaSet item, ListOptions options, Watcher<ReplicaSet> watcher) {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public ReplicaSet waitUntilReady(OkHttpClient client, Config config, String namespace, ReplicaSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ReplicaSet waitUntilCondition(OkHttpClient client, Config config, String namespace, ReplicaSet item, Predicate<ReplicaSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
