package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CustomResourceFluentImpl<S,T,A extends CustomResourceFluent<S,T,A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CustomResourceFluent<S,T,A> {

    private ObjectMeta metadata;
    private S spec;
    private T status;
    private String kind;
    private String apiVersion;

    public CustomResourceFluentImpl() {
    }

    public CustomResourceFluentImpl(CustomResource<S,T> instance) {
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.withKind(instance.getKind());
        
        this.withApiVersion(instance.getApiVersion());
    }

    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ObjectMeta metadata) {
        this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public S getSpec() {
        return this.spec;
    }

    public A withSpec(S spec) {
        this.spec=spec; return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public T getStatus() {
        return this.status;
    }

    public A withStatus(T status) {
        this.status=status; return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomResourceFluentImpl that = (CustomResourceFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  spec,  status,  kind,  apiVersion,  super.hashCode());
    }

}
