package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LeaderElectionConfigBuilder extends LeaderElectionConfigFluentImpl<LeaderElectionConfigBuilder> implements VisitableBuilder<LeaderElectionConfig,LeaderElectionConfigBuilder> {

    LeaderElectionConfigFluent<?> fluent;
    Boolean validationEnabled;

    public LeaderElectionConfigBuilder() {
        this(true);
    }

    public LeaderElectionConfigBuilder(Boolean validationEnabled) {
        this.fluent = this; this.validationEnabled=validationEnabled;
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent,Boolean validationEnabled) {
        this.fluent = fluent; this.validationEnabled=validationEnabled;
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent,LeaderElectionConfig instance) {
        this(fluent, instance, true);
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfigFluent<?> fluent,LeaderElectionConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLock(instance.getLock()); 
        fluent.withLeaseDuration(instance.getLeaseDuration()); 
        fluent.withRenewDeadline(instance.getRenewDeadline()); 
        fluent.withRetryPeriod(instance.getRetryPeriod()); 
        fluent.withLeaderCallbacks(instance.getLeaderCallbacks()); 
        fluent.withReleaseOnCancel(instance.isReleaseOnCancel()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfig instance) {
        this(instance,true);
    }

    public LeaderElectionConfigBuilder(LeaderElectionConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLock(instance.getLock()); 
        this.withLeaseDuration(instance.getLeaseDuration()); 
        this.withRenewDeadline(instance.getRenewDeadline()); 
        this.withRetryPeriod(instance.getRetryPeriod()); 
        this.withLeaderCallbacks(instance.getLeaderCallbacks()); 
        this.withReleaseOnCancel(instance.isReleaseOnCancel()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public LeaderElectionConfig build() {
        LeaderElectionConfig buildable = new LeaderElectionConfig(fluent.getLock(),fluent.getLeaseDuration(),fluent.getRenewDeadline(),fluent.getRetryPeriod(),fluent.getLeaderCallbacks(),fluent.isReleaseOnCancel(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LeaderElectionConfigBuilder that = (LeaderElectionConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
