/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.http.WebSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public interface HttpClient
extends AutoCloseable {
    @Override
    public void close();

    public Builder newBuilder();

    public <T> HttpResponse<T> send(HttpRequest var1, Class<T> var2) throws IOException;

    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest var1, Class<T> var2);

    public WebSocket.Builder newWebSocketBuilder();

    public HttpRequest.Builder newHttpRequestBuilder();

    public static interface Builder {
        public HttpClient build();

        public Builder readTimeout(long var1, TimeUnit var3);

        public Builder connectTimeout(long var1, TimeUnit var3);

        public Builder forStreaming();

        public Builder writeTimeout(long var1, TimeUnit var3);

        public Builder addOrReplaceInterceptor(String var1, Interceptor var2);

        public Builder authenticatorNone();

        public Builder sslContext(SSLContext var1, TrustManager[] var2);

        public Builder followAllRedirects();

        public Builder proxyAddress(InetSocketAddress var1);

        public Builder proxyAuthorization(String var1);

        public Builder tlsVersions(TlsVersion[] var1);

        public Builder preferHttp11();
    }

    public static interface Factory {
        public HttpClient createHttpClient(Config var1);

        public Builder newBuilder();
    }
}

