
                                          

package io.fabric8.kubernetes.client.handlers.autoscaling.v2beta2;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.autoscaling.v2beta2.HorizontalPodAutoscalerOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.HorizontalPodAutoscalerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class HorizontalPodAutoscalerHandler implements ResourceHandler<HorizontalPodAutoscaler, HorizontalPodAutoscalerBuilder> {

  @Override
  public String getKind() {
    return HorizontalPodAutoscaler.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "autoscaling/v2beta2";
      }

  @Override
  public HorizontalPodAutoscaler create(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, boolean dryRun) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public HorizontalPodAutoscaler replace(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, boolean dryRun) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public HorizontalPodAutoscaler reload(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public HorizontalPodAutoscalerBuilder edit(HorizontalPodAutoscaler item) {
    return new HorizontalPodAutoscalerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, HorizontalPodAutoscaler item, boolean dryRun) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, Watcher<HorizontalPodAutoscaler> watcher) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, String resourceVersion, Watcher<HorizontalPodAutoscaler> watcher) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, ListOptions options, Watcher<HorizontalPodAutoscaler> watcher) {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public HorizontalPodAutoscaler waitUntilReady(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public HorizontalPodAutoscaler waitUntilCondition(OkHttpClient client, Config config, String namespace, HorizontalPodAutoscaler item, Predicate<HorizontalPodAutoscaler> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new HorizontalPodAutoscalerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
