
                                          

package io.fabric8.kubernetes.client.handlers.extensions.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.DaemonSetOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class DaemonSetHandler implements ResourceHandler<DaemonSet, DaemonSetBuilder> {

  @Override
  public String getKind() {
    return DaemonSet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "extensions/v1beta1";
      }

  @Override
  public DaemonSet create(OkHttpClient client, Config config, String namespace, DaemonSet item, boolean dryRun) {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public DaemonSet replace(OkHttpClient client, Config config, String namespace, DaemonSet item, boolean dryRun) {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public DaemonSet reload(OkHttpClient client, Config config, String namespace, DaemonSet item) {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public DaemonSetBuilder edit(DaemonSet item) {
    return new DaemonSetBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, DaemonSet item, boolean dryRun) {
    return new DaemonSetOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, DaemonSet item, Watcher<DaemonSet> watcher) {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, DaemonSet item, String resourceVersion, Watcher<DaemonSet> watcher) {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, DaemonSet item, ListOptions options, Watcher<DaemonSet> watcher) {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public DaemonSet waitUntilReady(OkHttpClient client, Config config, String namespace, DaemonSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public DaemonSet waitUntilCondition(OkHttpClient client, Config config, String namespace, DaemonSet item, Predicate<DaemonSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new DaemonSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
