package io.fabric8.kubernetes.client.extended.run;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

public interface RunConfigFluent<A extends RunConfigFluent<A>> extends Fluent<A> {


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(StringBuilder arg1);
    public A withNewName(int[] arg1,int arg2,int arg3);
    public A withNewName(char[] arg1);
    public A withNewName(StringBuffer arg1);
    public A withNewName(byte[] arg1,int arg2);
    public A withNewName(byte[] arg1);
    public A withNewName(char[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3);
    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewName(String arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getImagePullPolicy();
    public A withImagePullPolicy(String imagePullPolicy);
    public Boolean hasImagePullPolicy();
    public A withNewImagePullPolicy(StringBuilder arg1);
    public A withNewImagePullPolicy(int[] arg1,int arg2,int arg3);
    public A withNewImagePullPolicy(char[] arg1);
    public A withNewImagePullPolicy(StringBuffer arg1);
    public A withNewImagePullPolicy(byte[] arg1,int arg2);
    public A withNewImagePullPolicy(byte[] arg1);
    public A withNewImagePullPolicy(char[] arg1,int arg2,int arg3);
    public A withNewImagePullPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewImagePullPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImagePullPolicy(String arg1);
    public String getCommand();
    public A withCommand(String command);
    public Boolean hasCommand();
    public A withNewCommand(StringBuilder arg1);
    public A withNewCommand(int[] arg1,int arg2,int arg3);
    public A withNewCommand(char[] arg1);
    public A withNewCommand(StringBuffer arg1);
    public A withNewCommand(byte[] arg1,int arg2);
    public A withNewCommand(byte[] arg1);
    public A withNewCommand(char[] arg1,int arg2,int arg3);
    public A withNewCommand(byte[] arg1,int arg2,int arg3);
    public A withNewCommand(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCommand(String arg1);
    public A addToArgs(int index,String item);
    public A setToArgs(int index,String item);
    public A addToArgs(String... items);
    public A addAllToArgs(Collection<String> items);
    public A removeFromArgs(String... items);
    public A removeAllFromArgs(Collection<String> items);
    public List<String> getArgs();
    public String getArg(int index);
    public String getFirstArg();
    public String getLastArg();
    public String getMatchingArg(Predicate<String> predicate);
    public Boolean hasMatchingArg(Predicate<String> predicate);
    public A withArgs(List<String> args);
    public A withArgs(String... args);
    public Boolean hasArgs();
    public A addNewArg(StringBuilder arg1);
    public A addNewArg(int[] arg1,int arg2,int arg3);
    public A addNewArg(char[] arg1);
    public A addNewArg(StringBuffer arg1);
    public A addNewArg(byte[] arg1,int arg2);
    public A addNewArg(byte[] arg1);
    public A addNewArg(char[] arg1,int arg2,int arg3);
    public A addNewArg(byte[] arg1,int arg2,int arg3);
    public A addNewArg(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewArg(String arg1);
    public String getRestartPolicy();
    public A withRestartPolicy(String restartPolicy);
    public Boolean hasRestartPolicy();
    public A withNewRestartPolicy(StringBuilder arg1);
    public A withNewRestartPolicy(int[] arg1,int arg2,int arg3);
    public A withNewRestartPolicy(char[] arg1);
    public A withNewRestartPolicy(StringBuffer arg1);
    public A withNewRestartPolicy(byte[] arg1,int arg2);
    public A withNewRestartPolicy(byte[] arg1);
    public A withNewRestartPolicy(char[] arg1,int arg2,int arg3);
    public A withNewRestartPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewRestartPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewRestartPolicy(String arg1);
    public String getServiceAccount();
    public A withServiceAccount(String serviceAccount);
    public Boolean hasServiceAccount();
    public A withNewServiceAccount(StringBuilder arg1);
    public A withNewServiceAccount(int[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(char[] arg1);
    public A withNewServiceAccount(StringBuffer arg1);
    public A withNewServiceAccount(byte[] arg1,int arg2);
    public A withNewServiceAccount(byte[] arg1);
    public A withNewServiceAccount(char[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3);
    public A withNewServiceAccount(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceAccount(String arg1);
    public A addToLabels(String key,String value);
    public A addToLabels(java.util.Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(java.util.Map<String,String> map);
    public java.util.Map<String,String> getLabels();
    public <K extends Object,V extends Object>A withLabels(java.util.Map<String,String> labels);
    public Boolean hasLabels();
    public A addToEnv(String key,String value);
    public A addToEnv(java.util.Map<String,String> map);
    public A removeFromEnv(String key);
    public A removeFromEnv(java.util.Map<String,String> map);
    public java.util.Map<String,String> getEnv();
    public <K extends Object,V extends Object>A withEnv(java.util.Map<String,String> env);
    public Boolean hasEnv();
    public A addToLimits(String key,Quantity value);
    public A addToLimits(java.util.Map<String,Quantity> map);
    public A removeFromLimits(String key);
    public A removeFromLimits(java.util.Map<String,Quantity> map);
    public java.util.Map<String,Quantity> getLimits();
    public <K extends Object,V extends Object>A withLimits(java.util.Map<String,Quantity> limits);
    public Boolean hasLimits();
    public A addToRequests(String key,Quantity value);
    public A addToRequests(java.util.Map<String,Quantity> map);
    public A removeFromRequests(String key);
    public A removeFromRequests(java.util.Map<String,Quantity> map);
    public java.util.Map<String,Quantity> getRequests();
    public <K extends Object,V extends Object>A withRequests(java.util.Map<String,Quantity> requests);
    public Boolean hasRequests();
    public int getPort();
    public A withPort(int port);
    public Boolean hasPort();
}
