
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ComponentStatusOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ComponentStatus;
import io.fabric8.kubernetes.api.model.ComponentStatusBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ComponentStatusHandler implements ResourceHandler<ComponentStatus, ComponentStatusBuilder> {

  @Override
  public String getKind() {
    return ComponentStatus.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public ComponentStatus create(OkHttpClient client, Config config, String namespace, ComponentStatus item, boolean dryRun) {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ComponentStatus replace(OkHttpClient client, Config config, String namespace, ComponentStatus item, boolean dryRun) {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ComponentStatus reload(OkHttpClient client, Config config, String namespace, ComponentStatus item) {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ComponentStatusBuilder edit(ComponentStatus item) {
    return new ComponentStatusBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ComponentStatus item, boolean dryRun) {
    return new ComponentStatusOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ComponentStatus item, Watcher<ComponentStatus> watcher) {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ComponentStatus item, String resourceVersion, Watcher<ComponentStatus> watcher) {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ComponentStatus item, ListOptions options, Watcher<ComponentStatus> watcher) {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public ComponentStatus waitUntilReady(OkHttpClient client, Config config, String namespace, ComponentStatus item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ComponentStatus waitUntilCondition(OkHttpClient client, Config config, String namespace, ComponentStatus item, Predicate<ComponentStatus> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ComponentStatusOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
