
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.ResourceQuotaOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ResourceQuotaHandler implements ResourceHandler<ResourceQuota, ResourceQuotaBuilder> {

  @Override
  public String getKind() {
    return ResourceQuota.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public ResourceQuota create(OkHttpClient client, Config config, String namespace, ResourceQuota item, boolean dryRun) {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ResourceQuota replace(OkHttpClient client, Config config, String namespace, ResourceQuota item, boolean dryRun) {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ResourceQuota reload(OkHttpClient client, Config config, String namespace, ResourceQuota item) {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ResourceQuotaBuilder edit(ResourceQuota item) {
    return new ResourceQuotaBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ResourceQuota item, boolean dryRun) {
    return new ResourceQuotaOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, Watcher<ResourceQuota> watcher) {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, String resourceVersion, Watcher<ResourceQuota> watcher) {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ResourceQuota item, ListOptions options, Watcher<ResourceQuota> watcher) {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public ResourceQuota waitUntilReady(OkHttpClient client, Config config, String namespace, ResourceQuota item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ResourceQuota waitUntilCondition(OkHttpClient client, Config config, String namespace, ResourceQuota item, Predicate<ResourceQuota> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ResourceQuotaOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
