package io.fabric8.kubernetes.client.extended.leaderelection;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LeaderElectionConfigBuilder extends io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluentImpl<io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig,io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigBuilder> {

    io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public LeaderElectionConfigBuilder() {
        this(true);
    }

    public LeaderElectionConfigBuilder(java.lang.Boolean validationEnabled) {
        this.fluent = this; this.validationEnabled=validationEnabled;
    }

    public LeaderElectionConfigBuilder(io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public LeaderElectionConfigBuilder(io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; this.validationEnabled=validationEnabled;
    }

    public LeaderElectionConfigBuilder(io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent<?> fluent,io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig instance) {
        this(fluent, instance, true);
    }

    public LeaderElectionConfigBuilder(io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent<?> fluent,io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLock(instance.getLock()); 
        fluent.withLeaseDuration(instance.getLeaseDuration()); 
        fluent.withRenewDeadline(instance.getRenewDeadline()); 
        fluent.withRetryPeriod(instance.getRetryPeriod()); 
        fluent.withLeaderCallbacks(instance.getLeaderCallbacks()); 
        fluent.withReleaseOnCancel(instance.isReleaseOnCancel()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public LeaderElectionConfigBuilder(io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig instance) {
        this(instance,true);
    }

    public LeaderElectionConfigBuilder(io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLock(instance.getLock()); 
        this.withLeaseDuration(instance.getLeaseDuration()); 
        this.withRenewDeadline(instance.getRenewDeadline()); 
        this.withRetryPeriod(instance.getRetryPeriod()); 
        this.withLeaderCallbacks(instance.getLeaderCallbacks()); 
        this.withReleaseOnCancel(instance.isReleaseOnCancel()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig build() {
        LeaderElectionConfig buildable = new LeaderElectionConfig(fluent.getLock(),fluent.getLeaseDuration(),fluent.getRenewDeadline(),fluent.getRetryPeriod(),fluent.getLeaderCallbacks(),fluent.isReleaseOnCancel(),fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LeaderElectionConfigBuilder that = (LeaderElectionConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
