
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.PersistentVolumeClaimOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PersistentVolumeClaimHandler implements ResourceHandler<PersistentVolumeClaim, PersistentVolumeClaimBuilder> {

  @Override
  public String getKind() {
    return PersistentVolumeClaim.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public PersistentVolumeClaim create(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item, boolean dryRun) {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PersistentVolumeClaim replace(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item, boolean dryRun) {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PersistentVolumeClaim reload(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item) {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PersistentVolumeClaimBuilder edit(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PersistentVolumeClaim item, boolean dryRun) {
    return new PersistentVolumeClaimOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item, Watcher<PersistentVolumeClaim> watcher) {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item, String resourceVersion, Watcher<PersistentVolumeClaim> watcher) {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item, ListOptions options, Watcher<PersistentVolumeClaim> watcher) {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public PersistentVolumeClaim waitUntilReady(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PersistentVolumeClaim waitUntilCondition(OkHttpClient client, Config config, String namespace, PersistentVolumeClaim item, Predicate<PersistentVolumeClaim> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PersistentVolumeClaimOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
