
                                          

package io.fabric8.kubernetes.client.handlers.flowcontrol.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.flowcontrol.v1beta1.PriorityLevelConfigurationOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PriorityLevelConfiguration;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PriorityLevelConfigurationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PriorityLevelConfigurationHandler implements ResourceHandler<PriorityLevelConfiguration, PriorityLevelConfigurationBuilder> {

  @Override
  public String getKind() {
    return PriorityLevelConfiguration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "flowcontrol.apiserver.k8s.io/v1beta1";
      }

  @Override
  public PriorityLevelConfiguration create(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item, boolean dryRun) {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PriorityLevelConfiguration replace(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item, boolean dryRun) {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PriorityLevelConfiguration reload(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item) {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PriorityLevelConfigurationBuilder edit(PriorityLevelConfiguration item) {
    return new PriorityLevelConfigurationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PriorityLevelConfiguration item, boolean dryRun) {
    return new PriorityLevelConfigurationOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item, Watcher<PriorityLevelConfiguration> watcher) {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item, String resourceVersion, Watcher<PriorityLevelConfiguration> watcher) {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item, ListOptions options, Watcher<PriorityLevelConfiguration> watcher) {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public PriorityLevelConfiguration waitUntilReady(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PriorityLevelConfiguration waitUntilCondition(OkHttpClient client, Config config, String namespace, PriorityLevelConfiguration item, Predicate<PriorityLevelConfiguration> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PriorityLevelConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
