
                                          

package io.fabric8.kubernetes.client.handlers.rbac.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.rbac.v1.ClusterRoleBindingOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ClusterRoleBindingHandler implements ResourceHandler<ClusterRoleBinding, ClusterRoleBindingBuilder> {

  @Override
  public String getKind() {
    return ClusterRoleBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
      }

  @Override
  public ClusterRoleBinding create(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, boolean dryRun) {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ClusterRoleBinding replace(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, boolean dryRun) {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ClusterRoleBinding reload(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item) {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ClusterRoleBindingBuilder edit(ClusterRoleBinding item) {
    return new ClusterRoleBindingBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ClusterRoleBinding item, boolean dryRun) {
    return new ClusterRoleBindingOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, Watcher<ClusterRoleBinding> watcher) {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, String resourceVersion, Watcher<ClusterRoleBinding> watcher) {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, ListOptions options, Watcher<ClusterRoleBinding> watcher) {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public ClusterRoleBinding waitUntilReady(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ClusterRoleBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item, Predicate<ClusterRoleBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ClusterRoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
