
                                          
      

package io.fabric8.kubernetes.client.dsl.internal.batch.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.batch.v1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.CronJobList;

import java.util.Map;
import java.util.TreeMap;


public class CronJobOperationsImpl extends HasMetadataOperation<CronJob, CronJobList, Resource<CronJob>> {

  public CronJobOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public CronJobOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CronJobOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("batch")
    .withApiGroupVersion("v1")
    .withPlural("cronjobs"));
    this.type = CronJob.class;
    this.listType = CronJobList.class;
  }

  public CronJobOperationsImpl newInstance(OperationContext context) {
    return new CronJobOperationsImpl(context);
  }

  @Override
  public CronJob edit(Visitor... visitors) {
    return patch(new CronJobBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
