
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.APIServiceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.APIService;
import io.fabric8.kubernetes.api.model.APIServiceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class APIServiceHandler implements ResourceHandler<APIService, APIServiceBuilder> {

  @Override
  public String getKind() {
    return APIService.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apiregistration.k8s.io/v1";
      }

  @Override
  public APIService create(OkHttpClient client, Config config, String namespace, APIService item, boolean dryRun) {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public APIService replace(OkHttpClient client, Config config, String namespace, APIService item, boolean dryRun) {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public APIService reload(OkHttpClient client, Config config, String namespace, APIService item) {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public APIServiceBuilder edit(APIService item) {
    return new APIServiceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, APIService item, boolean dryRun) {
    return new APIServiceOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, Watcher<APIService> watcher) {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, String resourceVersion, Watcher<APIService> watcher) {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, APIService item, ListOptions options, Watcher<APIService> watcher) {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public APIService waitUntilReady(OkHttpClient client, Config config, String namespace, APIService item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public APIService waitUntilCondition(OkHttpClient client, Config config, String namespace, APIService item, Predicate<APIService> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new APIServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
