package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import org.slf4j.Logger;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

  
  /**
   * A base class for implementing a custom resource kind. Implementations must be annotated with
   * {@link io.fabric8.kubernetes.model.annotation.Group} and {@link io.fabric8.kubernetes.model.annotation.Version}.
   * Properties are set up automatically as follows:
   * <ul>
   * <li>group is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getGroup(Class)}</li>
   * <li>version is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getVersion(Class)}</li>
   * <li>singular is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getSingular(Class)}</li>
   * <li>plural is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getPlural(Class)}</li>
   * <li>computed CRD name using {@link CustomResource#getCRDName(Class)}</li>
   * </ul>
   * In addition, {@link CustomResource#setApiVersion(String)} and {@link CustomResource#setKind(String)} are overridden to not do anything since these values
   * are set.
   * @param <S> the class providing the {@code Spec} part of this CustomResource
   * @param <T> the class providing the {@code Status} part of this CustomResource
   */
  public interface CustomResourceFluent<S,T,A extends io.fabric8.kubernetes.client.CustomResourceFluent<S,T,A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata();
    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata();
    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata);
    public java.lang.Boolean hasMetadata();
    public io.fabric8.kubernetes.client.CustomResourceFluent.MetadataNested<A> withNewMetadata();
    public io.fabric8.kubernetes.client.CustomResourceFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
    public io.fabric8.kubernetes.client.CustomResourceFluent.MetadataNested<A> editMetadata();
    public io.fabric8.kubernetes.client.CustomResourceFluent.MetadataNested<A> editOrNewMetadata();
    public io.fabric8.kubernetes.client.CustomResourceFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
    public S getSpec();
    public A withSpec(S spec);
    public java.lang.Boolean hasSpec();
    public T getStatus();
    public A withStatus(T status);
    public java.lang.Boolean hasStatus();
    public java.lang.String getKind();
    public A withKind(java.lang.String kind);
    public java.lang.Boolean hasKind();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0);
    public java.lang.String getApiVersion();
    public A withApiVersion(java.lang.String apiVersion);
    public java.lang.Boolean hasApiVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ObjectMetaFluent<io.fabric8.kubernetes.client.CustomResourceFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
