
                                          

package io.fabric8.kubernetes.client.handlers.admissionregistration.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.admissionregistration.v1.ValidatingWebhookConfigurationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfigurationBuilder;

public class ValidatingWebhookConfigurationHandler implements ResourceHandler<ValidatingWebhookConfiguration, ValidatingWebhookConfigurationBuilder> {

  @Override
  public String getKind() {
    return ValidatingWebhookConfiguration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "admissionregistration.k8s.io/v1";
      }

  @Override
  public ValidatingWebhookConfigurationBuilder edit(ValidatingWebhookConfiguration item) {
    return new ValidatingWebhookConfigurationBuilder(item);
  }

  @Override
  public Resource<ValidatingWebhookConfiguration> resource(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
