
                                          

package io.fabric8.kubernetes.client.handlers.apps.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;

public class ReplicaSetHandler implements ResourceHandler<ReplicaSet, ReplicaSetBuilder> {

  @Override
  public String getKind() {
    return ReplicaSet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "apps/v1";
      }

  @Override
  public ReplicaSetBuilder edit(ReplicaSet item) {
    return new ReplicaSetBuilder(item);
  }

  @Override
  public Resource<ReplicaSet> resource(OkHttpClient client, Config config, String namespace, ReplicaSet item) {
    return new ReplicaSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
