
                                          

package io.fabric8.kubernetes.client.handlers.batch.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.batch.v1beta1.CronJobOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobBuilder;

public class CronJobHandler implements ResourceHandler<CronJob, CronJobBuilder> {

  @Override
  public String getKind() {
    return CronJob.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "batch/v1beta1";
      }

  @Override
  public CronJobBuilder edit(CronJob item) {
    return new CronJobBuilder(item);
  }

  @Override
  public Resource<CronJob> resource(OkHttpClient client, Config config, String namespace, CronJob item) {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
