
                                          

package io.fabric8.kubernetes.client.handlers.extensions.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;

public class DeploymentHandler implements ResourceHandler<Deployment, DeploymentBuilder> {

  @Override
  public String getKind() {
    return Deployment.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "extensions/v1beta1";
      }

  @Override
  public DeploymentBuilder edit(Deployment item) {
    return new DeploymentBuilder(item);
  }

  @Override
  public Resource<Deployment> resource(OkHttpClient client, Config config, String namespace, Deployment item) {
    return new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
