
                                          

package io.fabric8.kubernetes.client.handlers.extensions.v1beta1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.extensions.v1beta1.NetworkPolicyOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.extensions.NetworkPolicy;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyBuilder;

public class NetworkPolicyHandler implements ResourceHandler<NetworkPolicy, NetworkPolicyBuilder> {

  @Override
  public String getKind() {
    return NetworkPolicy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "extensions/v1beta1";
      }

  @Override
  public NetworkPolicyBuilder edit(NetworkPolicy item) {
    return new NetworkPolicyBuilder(item);
  }

  @Override
  public Resource<NetworkPolicy> resource(OkHttpClient client, Config config, String namespace, NetworkPolicy item) {
    return new NetworkPolicyOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
