
                                          

package io.fabric8.kubernetes.client.handlers.networking.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.networking.v1.IngressOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.networking.v1.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;

public class IngressHandler implements ResourceHandler<Ingress, IngressBuilder> {

  @Override
  public String getKind() {
    return Ingress.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "networking.k8s.io/v1";
      }

  @Override
  public IngressBuilder edit(Ingress item) {
    return new IngressBuilder(item);
  }

  @Override
  public Resource<Ingress> resource(OkHttpClient client, Config config, String namespace, Ingress item) {
    return new IngressOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
