
                                          

package io.fabric8.kubernetes.client.handlers.storage.v1;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.internal.storage.v1.StorageClassOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.api.model.storage.StorageClassBuilder;

public class StorageClassHandler implements ResourceHandler<StorageClass, StorageClassBuilder> {

  @Override
  public String getKind() {
    return StorageClass.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "storage.k8s.io/v1";
      }

  @Override
  public StorageClassBuilder edit(StorageClass item) {
    return new StorageClassBuilder(item);
  }

  @Override
  public Resource<StorageClass> resource(OkHttpClient client, Config config, String namespace, StorageClass item) {
    return new StorageClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
