/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.utils.internal;

import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackoffIntervalCalculator {
    private static final Logger logger = LoggerFactory.getLogger(ExponentialBackoffIntervalCalculator.class);
    private final int initialInterval;
    private final int maxRetryIntervalExponent;
    final AtomicInteger currentReconnectAttempt = new AtomicInteger();

    public ExponentialBackoffIntervalCalculator(int initialInterval, int maxRetryIntervalExponent) {
        this.initialInterval = initialInterval;
        this.maxRetryIntervalExponent = maxRetryIntervalExponent;
    }

    public long getInterval(int retryIndex) {
        int exponentOfTwo = retryIndex;
        if (exponentOfTwo > this.maxRetryIntervalExponent) {
            exponentOfTwo = this.maxRetryIntervalExponent;
        }
        return (long)this.initialInterval * (long)(1 << exponentOfTwo);
    }

    public void resetReconnectAttempts() {
        this.currentReconnectAttempt.set(0);
    }

    public final long nextReconnectInterval() {
        int exponentOfTwo = this.currentReconnectAttempt.getAndIncrement();
        long ret = this.getInterval(exponentOfTwo);
        logger.debug("Current reconnect backoff is {} milliseconds (T{})", (Object)ret, (Object)exponentOfTwo);
        return ret;
    }

    public int getCurrentReconnectAttempt() {
        return this.currentReconnectAttempt.get();
    }
}

