/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.impl;

import io.fabric8.kubernetes.api.model.APIGroup;
import io.fabric8.kubernetes.api.model.APIGroupList;
import io.fabric8.kubernetes.api.model.APIResourceList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.extension.ExtensionAdapter;
import io.fabric8.kubernetes.client.extension.SupportTestingClient;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.impl.Adapters;
import io.fabric8.kubernetes.client.impl.Handlers;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;

public abstract class BaseClient
implements Client {
    public static final KubernetesClientBuilder.ExecutorSupplier DEFAULT_EXECUTOR_SUPPLIER = new KubernetesClientBuilder.ExecutorSupplier(){

        public Executor get() {
            return Executors.newCachedThreadPool(Utils.daemonThreadFactory((Object)this));
        }

        public void onClose(Executor executor) {
            ((ExecutorService)executor).shutdownNow();
        }
    };
    public static final String APIS = "/apis";
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Predicate<String> matchingGroupPredicate;
    private final Adapters adapters;
    private final Handlers handlers;
    protected Config config;
    protected HttpClient httpClient;
    private OperationSupport operationSupport;
    private KubernetesClientBuilder.ExecutorSupplier executorSupplier;
    private Executor executor;
    private OperationContext operationContext;

    BaseClient(Config config, BaseClient baseClient) {
        this.config = config;
        this.httpClient = baseClient.httpClient.newBuilder().requestConfig(config).build();
        this.adapters = baseClient.adapters;
        this.handlers = baseClient.handlers;
        this.matchingGroupPredicate = baseClient.matchingGroupPredicate;
        this.executorSupplier = baseClient.executorSupplier;
        this.executor = baseClient.executor;
        this.setDerivedFields();
    }

    BaseClient(HttpClient httpClient, Config config, KubernetesClientBuilder.ExecutorSupplier executorSupplier) {
        this.config = config;
        this.httpClient = httpClient;
        this.handlers = new Handlers();
        this.adapters = new Adapters(this.handlers);
        this.setDerivedFields();
        if (executorSupplier == null) {
            executorSupplier = DEFAULT_EXECUTOR_SUPPLIER;
        }
        this.executorSupplier = executorSupplier;
        this.executor = (Executor)executorSupplier.get();
    }

    protected void setDerivedFields() {
        this.namespace = this.config.getNamespace();
        this.apiVersion = this.config.getApiVersion();
        if (this.config.getMasterUrl() == null) {
            throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar((String)"kubernetes.master") + "\"");
        }
        try {
            this.masterUrl = new URL(this.config.getMasterUrl());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public synchronized void close() {
        this.httpClient.close();
        if (this.executorSupplier != null) {
            this.executorSupplier.onClose(this.executor);
            this.executorSupplier = null;
        }
    }

    public URL getMasterUrl() {
        return this.masterUrl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setMatchingGroupPredicate(Predicate<String> unsupportedApiGroups) {
        this.matchingGroupPredicate = unsupportedApiGroups;
    }

    public boolean hasApiGroup(String apiGroup, boolean exact) {
        if (this.matchingGroupPredicate != null) {
            return this.matchingGroupPredicate.test(apiGroup);
        }
        if (exact) {
            return this.getApiGroup(apiGroup) != null;
        }
        APIGroupList apiGroups = this.getApiGroups();
        if (apiGroups == null) {
            return false;
        }
        return apiGroups.getGroups().stream().anyMatch(g -> g.getName().endsWith(apiGroup));
    }

    public <C extends Client> Boolean isAdaptable(Class<C> type) {
        C toTest = this.adapt(type);
        if (toTest instanceof SupportTestingClient) {
            return ((SupportTestingClient)toTest).isSupported();
        }
        return true;
    }

    public <R extends KubernetesResource> boolean supports(Class<R> type) {
        String typeApiVersion = HasMetadata.getApiVersion(type);
        if (this.matchingGroupPredicate != null) {
            return this.matchingGroupPredicate.test(typeApiVersion);
        }
        String typeKind = HasMetadata.getKind(type);
        if (Utils.isNullOrEmpty((String)typeApiVersion) || Utils.isNullOrEmpty((String)typeKind)) {
            return false;
        }
        APIResourceList apiResources = this.getApiResources(ApiVersionUtil.joinApiGroupAndVersion((String)HasMetadata.getGroup(type), (String)HasMetadata.getVersion(type)));
        if (apiResources == null) {
            return false;
        }
        return apiResources.getResources().stream().anyMatch(r -> typeKind.equals(r.getKind()));
    }

    public <C extends Client> C adapt(Class<C> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (C)this;
        }
        ExtensionAdapter<C> adapter = this.adapters.get(type);
        if (adapter == null) {
            throw new IllegalStateException("No adapter available for type:" + type);
        }
        return (C)adapter.adapt((Client)this);
    }

    public RootPaths rootPaths() {
        return this.getOperationSupport().restCall(RootPaths.class, new String[0]);
    }

    public boolean supportsApiPath(String apiPath) {
        List paths;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.equals(apiPath)) continue;
                return true;
            }
        }
        return false;
    }

    public APIGroupList getApiGroups() {
        return this.getOperationSupport().restCall(APIGroupList.class, APIS);
    }

    public APIGroup getApiGroup(String name) {
        return this.getOperationSupport().restCall(APIGroup.class, APIS, name);
    }

    private OperationSupport getOperationSupport() {
        if (this.operationSupport == null) {
            this.operationSupport = new OperationSupport(this);
        }
        return this.operationSupport;
    }

    public APIResourceList getApiResources(String groupVersion) {
        if ("v1".equals(groupVersion)) {
            return this.getOperationSupport().restCall(APIResourceList.class, "api", "v1");
        }
        return this.getOperationSupport().restCall(APIResourceList.class, APIS, groupVersion);
    }

    protected VersionInfo getVersionInfo(String path) {
        return this.getOperationSupport().restCall(VersionInfo.class, path);
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>> MixedOperation<T, L, R> resources(Class<T> resourceType, Class<L> listClass, Class<R> resourceClass) {
        if (GenericKubernetesResource.class.equals(resourceType)) {
            throw new KubernetesClientException("resources cannot be called with a generic type");
        }
        if (resourceType.isInterface()) {
            throw new IllegalArgumentException("resources cannot be called with an interface");
        }
        try {
            return this.handlers.getOperation(resourceType, listClass, this);
        }
        catch (Exception e) {
            if (resourceClass == null || Resource.class.equals(resourceClass)) {
                return this.newHasMetadataOperation(ResourceDefinitionContext.fromResourceType(resourceType), resourceType, listClass);
            }
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperationsImpl<T, L> newHasMetadataOperation(ResourceDefinitionContext rdContext, Class<T> resourceType, Class<L> listClass) {
        return new HasMetadataOperationsImpl<T, L>(this, rdContext, resourceType, listClass);
    }

    public Config getConfiguration() {
        return this.config;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Adapters getAdapters() {
        return this.adapters;
    }

    public Handlers getHandlers() {
        return this.handlers;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    public BaseClient operationContext(OperationContext operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    abstract BaseClient newInstance(Config var1);

    public Client newClient(OperationContext newContext) {
        return this.newInstance(this.config).operationContext(newContext);
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

